/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq;

import fork.lib.bio.seq.Nucleotide;
import java.util.HashMap;

public class CodonTranslator {
    private String seq;
    private boolean ifloop;
    public static HashMap<String, Character> tl = new HashMap();

    public CodonTranslator(String seq, boolean ifrev, boolean ifloop) {
        this.seq = ifrev ? Nucleotide.reverseComplement(seq) : seq;
        this.ifloop = ifloop;
    }

    public CodonTranslator(String seq) {
        this(seq, false, true);
    }

    private static String translate(String s) {
        int ind = 0;
        StringBuilder ret = new StringBuilder();
        while (ind + 3 <= s.length()) {
            Character c = tl.get(s.substring(ind, ind + 3));
            if (c == null) {
                c = Character.valueOf('X');
            }
            ret.append(c);
            ind += 3;
        }
        return ret.toString();
    }

    private String shift(int sh) {
        if (this.ifloop) {
            return this.seq.substring(sh) + this.seq.substring(0, sh);
        }
        return this.seq.substring(sh);
    }

    public String frame(int n) {
        return CodonTranslator.translate(this.shift(n));
    }

    public static void main(String[] args) throws Exception {
    }

    static {
        tl.put("AAA", Character.valueOf('K'));
        tl.put("AAT", Character.valueOf('N'));
        tl.put("AAC", Character.valueOf('N'));
        tl.put("AAG", Character.valueOf('K'));
        tl.put("TAA", Character.valueOf('*'));
        tl.put("TAT", Character.valueOf('Y'));
        tl.put("TAC", Character.valueOf('Y'));
        tl.put("TAG", Character.valueOf('*'));
        tl.put("CAA", Character.valueOf('Q'));
        tl.put("CAT", Character.valueOf('H'));
        tl.put("CAC", Character.valueOf('H'));
        tl.put("CAG", Character.valueOf('Q'));
        tl.put("GAA", Character.valueOf('E'));
        tl.put("GAT", Character.valueOf('D'));
        tl.put("GAC", Character.valueOf('D'));
        tl.put("GAG", Character.valueOf('E'));
        tl.put("ATA", Character.valueOf('I'));
        tl.put("ATT", Character.valueOf('I'));
        tl.put("ATC", Character.valueOf('I'));
        tl.put("ATG", Character.valueOf('M'));
        tl.put("TTA", Character.valueOf('L'));
        tl.put("TTT", Character.valueOf('F'));
        tl.put("TTC", Character.valueOf('F'));
        tl.put("TTG", Character.valueOf('L'));
        tl.put("CTA", Character.valueOf('L'));
        tl.put("CTT", Character.valueOf('L'));
        tl.put("CTC", Character.valueOf('L'));
        tl.put("CTG", Character.valueOf('L'));
        tl.put("GTA", Character.valueOf('V'));
        tl.put("GTT", Character.valueOf('V'));
        tl.put("GTC", Character.valueOf('V'));
        tl.put("GTG", Character.valueOf('V'));
        tl.put("ACA", Character.valueOf('T'));
        tl.put("ACT", Character.valueOf('T'));
        tl.put("ACC", Character.valueOf('T'));
        tl.put("ACG", Character.valueOf('T'));
        tl.put("TCA", Character.valueOf('S'));
        tl.put("TCT", Character.valueOf('S'));
        tl.put("TCC", Character.valueOf('S'));
        tl.put("TCG", Character.valueOf('S'));
        tl.put("CCA", Character.valueOf('P'));
        tl.put("CCT", Character.valueOf('P'));
        tl.put("CCC", Character.valueOf('P'));
        tl.put("CCG", Character.valueOf('P'));
        tl.put("GCA", Character.valueOf('A'));
        tl.put("GCT", Character.valueOf('A'));
        tl.put("GCC", Character.valueOf('A'));
        tl.put("GCG", Character.valueOf('A'));
        tl.put("AGA", Character.valueOf('R'));
        tl.put("AGT", Character.valueOf('S'));
        tl.put("AGC", Character.valueOf('S'));
        tl.put("AGG", Character.valueOf('R'));
        tl.put("TGA", Character.valueOf('*'));
        tl.put("TGT", Character.valueOf('C'));
        tl.put("TGC", Character.valueOf('C'));
        tl.put("TGG", Character.valueOf('W'));
        tl.put("CGA", Character.valueOf('R'));
        tl.put("CGT", Character.valueOf('R'));
        tl.put("CGC", Character.valueOf('R'));
        tl.put("CGG", Character.valueOf('R'));
        tl.put("GGA", Character.valueOf('G'));
        tl.put("GGT", Character.valueOf('G'));
        tl.put("GGC", Character.valueOf('G'));
        tl.put("GGG", Character.valueOf('G'));
    }
}

