/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq;

import java.util.HashMap;

public class Nucleotide {
    public static HashMap<Character, Character> comp = new HashMap();
    public static final char NUCLEOTIDE = 'N';
    public static final char NUCLEOTIDE_L = 'n';
    public static final char ADENOSINE = 'A';
    public static final char ADENOSINE_L = 'a';
    public static final char GUANINE = 'G';
    public static final char GUANINE_L = 'g';
    public static final char THYMINE = 'T';
    public static final char THYMINE_L = 't';
    public static final char CYTOSINE = 'C';
    public static final char CYTOSINE_L = 'c';
    public static final char URACIL = 'U';
    public static final char URACIL_L = 'u';

    public static char complementaryNucleotide(char n) {
        if (comp.containsKey(Character.valueOf(n))) {
            return comp.get(Character.valueOf(n)).charValue();
        }
        return n;
    }

    public static String reverseComplement(String seq) {
        return String.valueOf(Nucleotide.reverseComplement(seq.toCharArray()));
    }

    public static char[] reverseComplement(char[] cs) {
        char[] ret = new char[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            ret[ret.length - 1 - i] = Nucleotide.complementaryNucleotide(cs[i]);
        }
        return ret;
    }

    public static String pairedSequence(String seq) {
        return String.valueOf(Nucleotide.pairedSequence(seq.toCharArray()));
    }

    public static char[] pairedSequence(char[] cs) {
        char[] ret = new char[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            ret[i] = Nucleotide.complementaryNucleotide(cs[i]);
        }
        return ret;
    }

    static {
        comp.put(Character.valueOf('N'), Character.valueOf('N'));
        comp.put(Character.valueOf('A'), Character.valueOf('T'));
        comp.put(Character.valueOf('G'), Character.valueOf('C'));
        comp.put(Character.valueOf('T'), Character.valueOf('A'));
        comp.put(Character.valueOf('C'), Character.valueOf('G'));
        comp.put(Character.valueOf('U'), Character.valueOf('A'));
        comp.put(Character.valueOf('n'), Character.valueOf('n'));
        comp.put(Character.valueOf('a'), Character.valueOf('t'));
        comp.put(Character.valueOf('g'), Character.valueOf('c'));
        comp.put(Character.valueOf('t'), Character.valueOf('a'));
        comp.put(Character.valueOf('c'), Character.valueOf('g'));
        comp.put(Character.valueOf('u'), Character.valueOf('a'));
        comp.put(Character.valueOf('('), Character.valueOf(')'));
        comp.put(Character.valueOf(')'), Character.valueOf('('));
        comp.put(Character.valueOf('['), Character.valueOf(']'));
        comp.put(Character.valueOf(']'), Character.valueOf('['));
        comp.put(Character.valueOf('{'), Character.valueOf('}'));
        comp.put(Character.valueOf('}'), Character.valueOf('{'));
        comp.put(Character.valueOf('<'), Character.valueOf('>'));
        comp.put(Character.valueOf('>'), Character.valueOf('<'));
    }
}

