/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.bio.seq.Sequence;
import fork.lib.bio.seq.align.PairAlignment;
import java.util.ArrayList;
import java.util.HashMap;

public class AlignmentParser {
    public static char GAP = (char)45;

    public static PairAlignment parsePairAlignment(String asa, String asb) throws Exception {
        if (asa.length() != asb.length()) {
            throw new Exception();
        }
        char[] as = asa.toCharArray();
        char[] bs = asb.toCharArray();
        int ia = -1;
        int ib = -1;
        HashMap<Integer, Integer> ab = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> ba = new HashMap<Integer, Integer>();
        ArrayList<Character> sba = new ArrayList<Character>();
        ArrayList<Character> sbb = new ArrayList<Character>();
        for (int i = 0; i < as.length; ++i) {
            char a = as[i];
            char b = bs[i];
            int tia = -1;
            int tib = -1;
            if (a != GAP) {
                sba.add(Character.valueOf(a));
                tia = ++ia;
            }
            if (b != GAP) {
                sbb.add(Character.valueOf(b));
                tib = ++ib;
            }
            ab.put(tia, tib);
            ba.put(tib, tia);
        }
        return new PairAlignment(new Sequence(sba), new Sequence(sbb), ab, ba);
    }
}

