/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.bio.seq.align.MotifFinderParam;
import fork.lib.bio.seq.parser.fasta.FastaReader;
import fork.lib.math.algebra.Algebra1D;
import fork.lib.math.applied.stat.FrequencyCount;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class MotifFinderNoBackground {
    protected Collection<String> seqs;
    protected MotifFinderParam par;

    public MotifFinderNoBackground(Collection<String> seqs, MotifFinderParam par) throws Exception {
        this.seqs = seqs;
        this.par = par;
        this.init();
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = new MotifFinderParam();
        }
    }

    public MotifFinderParam param() {
        return this.par;
    }

    public HashMap<String, Double> getMotifScores() {
        FrequencyCount<String> fc = new FrequencyCount<String>();
        Iterator<String> it = this.seqs.iterator();
        double n = 0.0;
        while (it.hasNext()) {
            String seq = it.next();
            for (int i = 0; i < seq.length() - this.par.size; ++i) {
                String ss = seq.substring(i, i + this.par.size);
                fc.add(ss);
            }
            n += 1.0;
        }
        double perm = Math.pow(4.0, this.par.size);
        HashMap<String, Double> ret = new HashMap<String, Double>();
        ArrayList ks = fc.keys();
        for (int i = 0; i < ks.size(); ++i) {
            String k = (String)ks.get(i);
            int count = fc.getCount(k);
            double nv = (double)count / n * perm;
            ret.put(k, nv);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("E:\\muxingu\\mystudy\\phd\\files\\");
        File d = new File(dir + "/other_datasets/lee_2007_nucleosome/pref/seq");
        File f = new File(d + "/seq_bin_9.fasta");
        MotifFinderParam par = new MotifFinderParam();
        par.size = 6;
        MotifFinderNoBackground mm = new MotifFinderNoBackground(new FastaReader(f).getAlSequences(), par);
        HashMap<String, Double> motval = mm.getMotifScores();
        String[] mots = new String[motval.size()];
        double[] vs = new double[motval.size()];
        Iterator<String> it = motval.keySet().iterator();
        int ind = 0;
        while (it.hasNext()) {
            String m;
            mots[ind] = m = it.next();
            vs[ind] = motval.get(m);
            ++ind;
        }
        int[] inds = Algebra1D.getReversedIndexForOrigin(vs);
        for (int i = 0; i < inds.length; ++i) {
            String m = mots[inds[i]];
            System.out.println(m + "   " + motval.get(m));
        }
    }
}

