/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.bio.seq.Nucleotide;
import fork.lib.bio.seq.align.Consensus;
import fork.lib.bio.seq.align.Motif;
import fork.lib.bio.seq.parser.bedgraph.BedGraphExporter;
import fork.lib.bio.seq.parser.fasta.FastaEntry;
import fork.lib.bio.seq.parser.fasta.FastaReader;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class MotifToLandscape {
    protected FastaReader fr;
    protected Motif mot;
    protected double thr = 2.0;

    public MotifToLandscape(FastaReader fr, Motif mot) {
        this.fr = fr;
        this.mot = mot;
    }

    public void setThreshold(double thr) {
        this.thr = thr;
    }

    public void writeToFile(File out, String tit) throws Exception {
        FastaEntry en;
        out.getParentFile().mkdirs();
        int len = this.mot.length();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        BedGraphExporter.writeTitle(bw, tit);
        while ((en = this.fr.nextEntry()) != null) {
            String chr = en.title();
            System.out.print(chr + " ");
            String seq = en.sequence();
            String seqi = Nucleotide.reverseComplement(seq);
            LandscapeBuilder lb = new LandscapeBuilder();
            double[] buff = new double[len];
            for (int i = 0; i < seq.length() - len; ++i) {
                double v;
                String ss = seq.substring(i, i + len);
                String ssi = seqi.substring(seqi.length() - (i + len), seqi.length() - i);
                double sc = Math.max(this.mot.align(ss), this.mot.align(ssi));
                if (i > 0 && (v = buff[0]) > this.thr) {
                    Region r = new Region(i, i);
                    r.setAttribute(v);
                    lb.add(chr, r);
                }
                for (int j = 0; j < buff.length - 1; ++j) {
                    double v2 = buff[j + 1];
                    buff[j] = v2 < sc ? sc : v2;
                }
                buff[buff.length - 1] = sc;
            }
            BedGraphExporter be = new BedGraphExporter(lb);
            be.appendToFile(bw);
        }
        bw.close();
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        File gen = new File("/home/forksapien/mystudy/phd/files/anno/genomes/sacCer1/sacCer1.fa");
        Consensus mot = new Consensus("CGG-----------CCG", Consensus.NUCLEOTIDES);
        File out = new File("/home/forksapien/mystudy/phd/files/test.txt");
        MotifToLandscape mm = new MotifToLandscape(new FastaReader(gen), mot);
        mm.writeToFile(out, "gal4_consensus");
    }
}

