/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.base.collection.Pair;
import fork.lib.base.format.StringOp;
import fork.lib.bio.seq.align.NeedlemanWunschParam;
import fork.lib.bio.seq.align.SubstitutionMatrix;
import fork.lib.math.algebra.Algebra1D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class NeedlemanWunsch {
    public static int maxAlns = 1000;
    protected String ref;
    protected String seq;
    protected NeedlemanWunschParam par;
    protected double[][] mat;
    protected double[][] matx;
    protected double[][] maty;
    protected ArrayList<Pair<String, String>> alns = new ArrayList();
    protected HashMap<ArrayIndex, ArrayList<ArrayIndex>> trace = new HashMap();

    public NeedlemanWunsch(String seq, String ref, NeedlemanWunschParam par) {
        this.ref = ref;
        this.seq = seq;
        this.par = par;
        if (par == null) {
            this.par = new NeedlemanWunschParam();
        }
    }

    public NeedlemanWunsch(String seq, String ref) {
        this(seq, ref, null);
    }

    private void printIDs() {
        System.out.println("mat: " + this.mat);
        System.out.println("matx: " + this.matx);
        System.out.println("maty: " + this.maty);
    }

    public void compute() {
        this.mat = new double[this.ref.length() + 1][this.seq.length() + 1];
        this.matx = new double[this.ref.length() + 1][this.seq.length() + 1];
        this.maty = new double[this.ref.length() + 1][this.seq.length() + 1];
        this.init();
        for (int i = 1; i < Math.min(this.mat.length, this.mat[0].length); ++i) {
            this.populateRound(i);
        }
        this.backTrack();
    }

    private void populateRound(int ind) {
        int indcol = ind >= this.mat[0].length - 1 ? this.mat[0].length - 1 : ind;
        for (int rowi = ind; rowi < this.mat.length; ++rowi) {
            this.populateCell(new Pair<Integer, Integer>(rowi, indcol));
        }
        int indrow = ind >= this.mat.length - 1 ? this.mat.length - 1 : ind;
        for (int coli = ind + 1; coli < this.mat[0].length; ++coli) {
            this.populateCell(new Pair<Integer, Integer>(indrow, coli));
        }
    }

    private void init() {
        int coli;
        int rowi;
        this.mat[0][0] = 0.0;
        for (rowi = 1; rowi < this.mat.length; ++rowi) {
            this.mat[rowi][0] = Double.NEGATIVE_INFINITY;
        }
        for (coli = 1; coli < this.mat[0].length; ++coli) {
            this.mat[0][coli] = Double.NEGATIVE_INFINITY;
        }
        for (rowi = 0; rowi < this.matx.length; ++rowi) {
            this.matx[rowi][0] = (double)rowi * this.par.gapExtensionPenalty + this.par.gapOpenPenalty;
            this.addToTrace(this.matx, rowi + 1, 0, this.matx, rowi, 0);
        }
        for (coli = 1; coli < this.matx[0].length; ++coli) {
            this.matx[0][coli] = Double.NEGATIVE_INFINITY;
        }
        for (rowi = 1; rowi < this.maty.length; ++rowi) {
            this.maty[rowi][0] = Double.NEGATIVE_INFINITY;
        }
        for (coli = 0; coli < this.maty[0].length; ++coli) {
            this.maty[0][coli] = (double)coli * this.par.gapExtensionPenalty + this.par.gapOpenPenalty;
            this.addToTrace(this.maty, 0, coli + 1, this.maty, 0, coli);
        }
    }

    private void populateCell(Pair<Integer, Integer> rci) {
        int ri = rci.a();
        int ci = rci.b();
        double incr = (Double)this.par.sub.getValueAt(Character.valueOf(this.ref.charAt(ri - 1)), Character.valueOf(this.seq.charAt(ci - 1)));
        double m1 = this.mat[ri - 1][ci - 1] + incr;
        double m2 = this.matx[ri - 1][ci - 1] + incr;
        double m3 = this.maty[ri - 1][ci - 1] + incr;
        this.mat[ri][ci] = Algebra1D.maxOf(m1, m2, m3);
        if (this.mat[ri][ci] == m1) {
            this.addToTrace(this.mat, ri, ci, this.mat, ri - 1, ci - 1);
        }
        if (this.mat[ri][ci] == m2) {
            this.addToTrace(this.mat, ri, ci, this.matx, ri - 1, ci - 1);
        }
        if (this.mat[ri][ci] == m3) {
            this.addToTrace(this.mat, ri, ci, this.maty, ri - 1, ci - 1);
        }
        double x1 = this.mat[ri - 1][ci] + this.par.gapOpenPenalty + this.par.gapExtensionPenalty;
        double x2 = this.matx[ri - 1][ci] + this.par.gapExtensionPenalty;
        this.matx[ri][ci] = Algebra1D.maxOf(x1, x2);
        if (this.matx[ri][ci] == x1) {
            this.addToTrace(this.matx, ri, ci, this.mat, ri - 1, ci);
        }
        if (this.matx[ri][ci] == x2) {
            this.addToTrace(this.matx, ri, ci, this.matx, ri - 1, ci);
        }
        double y1 = this.mat[ri][ci - 1] + this.par.gapOpenPenalty + this.par.gapExtensionPenalty;
        double y2 = this.maty[ri][ci - 1] + this.par.gapExtensionPenalty;
        this.maty[ri][ci] = Algebra1D.maxOf(y1, y2);
        if (this.maty[ri][ci] == y1) {
            this.addToTrace(this.maty, ri, ci, this.mat, ri, ci - 1);
        }
        if (this.maty[ri][ci] == y2) {
            this.addToTrace(this.maty, ri, ci, this.maty, ri, ci - 1);
        }
    }

    private void addToTrace(double[][] arr, int r, int c, double[][] marr, int mr, int mc) {
        ArrayIndex ai1 = new ArrayIndex(arr, new Pair<Integer, Integer>(r, c));
        ArrayIndex ai2 = new ArrayIndex(marr, new Pair<Integer, Integer>(mr, mc));
        if (!this.trace.containsKey(ai1)) {
            this.trace.put(ai1, new ArrayList());
        }
        this.trace.get(ai1).add(ai2);
    }

    public void backTrack() {
        int ix = this.mat.length - 1;
        int iy = this.mat[0].length - 1;
        double mm = this.mat[ix][iy];
        double mx = this.matx[ix][iy];
        double my = this.maty[ix][iy];
        double mmax = Algebra1D.maxOf(mm, mx, my);
        if (mm == mmax) {
            this.trackOneLevel(new ArrayIndex(this.mat, new Pair<Integer, Integer>(ix, iy)), new StringBuilder(), new StringBuilder());
        }
        if (mx == mmax) {
            this.trackOneLevel(new ArrayIndex(this.matx, new Pair<Integer, Integer>(ix, iy)), new StringBuilder(), new StringBuilder());
        }
        if (my == mmax) {
            this.trackOneLevel(new ArrayIndex(this.maty, new Pair<Integer, Integer>(ix, iy)), new StringBuilder(), new StringBuilder());
        }
    }

    private void trackOneLevel(ArrayIndex a, StringBuilder reftr, StringBuilder seqtr) {
        if (a.rc.a() == 0 && a.rc.b() == 0) {
            Pair<String, String> aln = new Pair<String, String>(StringOp.invert(seqtr.toString()), StringOp.invert(reftr.toString()));
            this.alns.add(aln);
            return;
        }
        if (this.alns.size() > maxAlns) {
            return;
        }
        ArrayList<ArrayIndex> tars = this.trace.get(a);
        for (ArrayIndex tar : tars) {
            StringBuilder reftr_ = new StringBuilder(reftr);
            StringBuilder seqtr_ = new StringBuilder(seqtr);
            if (tar.rc.a() == a.rc.a() - 1) {
                if (tar.rc.b() == a.rc.b() - 1) {
                    reftr_.append(this.ref.charAt(a.rc.a() - 1));
                    seqtr_.append(this.seq.charAt(a.rc.b() - 1));
                    this.trackOneLevel(tar, reftr_, seqtr_);
                    continue;
                }
                if (tar.rc.b() == a.rc.b()) {
                    reftr_.append(this.ref.charAt(a.rc.a() - 1));
                    seqtr_.append('-');
                    this.trackOneLevel(tar, reftr_, seqtr_);
                    continue;
                }
                System.err.println(a + "  " + tar);
                continue;
            }
            if (tar.rc.a() == a.rc.a()) {
                if (tar.rc.b() == a.rc.b() - 1) {
                    reftr_.append('-');
                    seqtr_.append(this.seq.charAt(a.rc.b() - 1));
                    this.trackOneLevel(tar, reftr_, seqtr_);
                    continue;
                }
                System.err.println(a + "  " + tar);
                continue;
            }
            System.err.println(a + "  " + tar);
        }
    }

    public void print(double[][] scores) {
        int i;
        System.out.print("x\t-");
        for (i = 0; i < this.seq.length(); ++i) {
            System.out.print("\t" + this.seq.charAt(i));
        }
        System.out.println();
        for (i = 0; i < scores.length; ++i) {
            System.out.print(i == 0 ? (char)'-' : this.ref.charAt(i - 1));
            for (int j = 0; j < scores[0].length; ++j) {
                System.out.print("\t" + scores[i][j]);
            }
            System.out.println();
        }
    }

    public void print() {
        this.print(this.mat);
        System.out.println();
        this.print(this.matx);
        System.out.println();
        this.print(this.maty);
        System.out.println();
        System.out.println("################");
        System.out.println("################");
    }

    public ArrayList<Pair<String, String>> alignments() {
        return this.alns;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            String seq = "TACCTACCCA";
            String ref = "CCCTCC";
            NeedlemanWunschParam par = new NeedlemanWunschParam();
            par.gapOpenPenalty = -5.0;
            par.gapExtensionPenalty = -1.0;
            par.sub = SubstitutionMatrix.generateMatrix(10.0, -10.0);
            NeedlemanWunsch aa = new NeedlemanWunsch(seq, ref, par);
            aa.compute();
            ArrayList<Pair<String, String>> alns = aa.alignments();
            for (Pair<String, String> p : alns) {
                System.out.println(p.a());
                System.out.println(p.b());
                System.out.println();
            }
        }
    }

    static class ArrayIndex {
        public double[][] arr;
        public Pair<Integer, Integer> rc;

        public ArrayIndex(double[][] arr, Pair<Integer, Integer> rc) {
            this.arr = arr;
            this.rc = rc;
        }

        public ArrayIndex(double[][] arr, int r, int c) {
            this.arr = arr;
            this.rc = new Pair<Integer, Integer>(r, c);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayIndex other = (ArrayIndex)obj;
            if (!Arrays.equals((Object[])this.arr, (Object[])other.arr)) {
                return false;
            }
            return Objects.equals(this.rc, other.rc);
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + Arrays.hashCode((Object[])this.arr);
            hash = 71 * hash + Objects.hashCode(this.rc);
            return hash;
        }

        public String toString() {
            return this.arr + "  " + this.rc;
        }
    }
}

