/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.base.collection.Pair;
import fork.lib.base.format.StringOp;
import fork.lib.bio.seq.align.NeedlemanWunschParam;
import java.util.ArrayList;
import java.util.HashMap;

public class NeedlemanWunschLinearGap {
    protected String ref;
    protected String seq;
    protected NeedlemanWunschParam par;
    protected double[][] scores;
    protected HashMap<Pair<Integer, Integer>, ArrayList<Pair<Integer, Integer>>> trace = new HashMap();
    protected ArrayList<Pair<String, String>> alns = new ArrayList();

    public NeedlemanWunschLinearGap(String seq, String ref, NeedlemanWunschParam par) {
        this.ref = ref;
        this.seq = seq;
        this.par = par;
        if (par == null) {
            this.par = new NeedlemanWunschParam();
        }
    }

    public NeedlemanWunschLinearGap(String seq, String ref) {
        this(seq, ref, null);
    }

    public void compute() {
        this.scores = new double[this.ref.length() + 1][this.seq.length() + 1];
        this.scores[0][0] = 0.0;
        this.init();
        for (int i = 1; i < Math.min(this.scores.length, this.scores[0].length); ++i) {
            this.populateRound(i);
        }
        this.backTrack();
    }

    private void init() {
        int ind = 0;
        double si = this.scores[ind][ind];
        for (int rowi = ind + 1; rowi < this.scores.length; ++rowi) {
            this.scores[rowi][ind] = si + (double)(rowi - ind) * this.par.gapOpenPenalty;
            this.addToTrace(rowi, ind, rowi - 1, ind);
        }
        for (int coli = ind + 1; coli < this.scores[0].length; ++coli) {
            this.scores[ind][coli] = si + (double)(coli - ind) * this.par.gapOpenPenalty;
            this.addToTrace(ind, coli, ind, coli - 1);
        }
    }

    private void addToTrace(int r, int c, int mr, int mc) {
        Pair<Integer, Integer> p = new Pair<Integer, Integer>(r, c);
        Pair<Integer, Integer> mp = new Pair<Integer, Integer>(mr, mc);
        if (!this.trace.containsKey(p)) {
            this.trace.put(p, new ArrayList());
        }
        this.trace.get(p).add(mp);
    }

    private void populateRound(int ind) {
        int indcol = ind >= this.scores[0].length - 1 ? this.scores[0].length - 1 : ind;
        for (int rowi = ind; rowi < this.scores.length; ++rowi) {
            this.populateCell(rowi, indcol);
        }
        int indrow = ind >= this.scores.length - 1 ? this.scores.length - 1 : ind;
        for (int coli = ind + 1; coli < this.scores[0].length; ++coli) {
            this.populateCell(indrow, coli);
        }
    }

    private void populateCell(int ri, int ci) {
        Character rc = Character.valueOf(this.ref.charAt(ri - 1));
        Character cc = Character.valueOf(this.seq.charAt(ci - 1));
        double incr = (Double)this.par.sub.getValueAt(rc, cc);
        double vleft = this.scores[ri][ci - 1] + this.par.gapOpenPenalty;
        double vup = this.scores[ri - 1][ci] + this.par.gapOpenPenalty;
        double vul = this.scores[ri - 1][ci - 1] + incr;
        this.scores[ri][ci] = Math.max(Math.max(vul, vup), vleft);
        if (vleft == this.scores[ri][ci]) {
            this.addToTrace(ri, ci, ri, ci - 1);
        }
        if (vup == this.scores[ri][ci]) {
            this.addToTrace(ri, ci, ri - 1, ci);
        }
        if (vul == this.scores[ri][ci]) {
            this.addToTrace(ri, ci, ri - 1, ci - 1);
        }
    }

    public void print() {
        int i;
        System.out.print("x\t-");
        for (i = 0; i < this.seq.length(); ++i) {
            System.out.print("\t" + this.seq.charAt(i));
        }
        System.out.println();
        for (i = 0; i < this.scores.length; ++i) {
            System.out.print(i == 0 ? (char)'-' : this.ref.charAt(i - 1));
            for (int j = 0; j < this.scores[0].length; ++j) {
                System.out.print("\t" + this.scores[i][j]);
            }
            System.out.println();
        }
    }

    private void backTrack() {
        Pair<Integer, Integer> p = new Pair<Integer, Integer>(this.scores.length - 1, this.scores[0].length - 1);
        StringBuilder reftr = new StringBuilder();
        StringBuilder seqtr = new StringBuilder();
        this.trackOneLevel(p, reftr, seqtr);
    }

    private void trackOneLevel(Pair<Integer, Integer> p, StringBuilder reftr, StringBuilder seqtr) {
        if (p.a() == 0 && p.b() == 0) {
            Pair<String, String> aln = new Pair<String, String>(StringOp.invert(reftr.toString()), StringOp.invert(seqtr.toString()));
            this.alns.add(aln);
            return;
        }
        ArrayList<Pair<Integer, Integer>> tars = this.trace.get(p);
        for (Pair<Integer, Integer> tar : tars) {
            StringBuilder reftr_ = new StringBuilder(reftr);
            StringBuilder seqtr_ = new StringBuilder(seqtr);
            if (tar.a() == p.a() - 1) {
                if (tar.b() == p.b() - 1) {
                    reftr_.append(this.ref.charAt(p.a() - 1));
                    seqtr_.append(this.seq.charAt(p.b() - 1));
                    this.trackOneLevel(tar, reftr_, seqtr_);
                    continue;
                }
                if (tar.b() == p.b()) {
                    reftr_.append(this.ref.charAt(p.a() - 1));
                    seqtr_.append('-');
                    this.trackOneLevel(tar, reftr_, seqtr_);
                    continue;
                }
                System.err.println(p + "  " + tar);
                continue;
            }
            if (tar.a() == p.a()) {
                if (tar.b() == p.b() - 1) {
                    reftr_.append('-');
                    seqtr_.append(this.seq.charAt(p.b() - 1));
                    this.trackOneLevel(tar, reftr_, seqtr_);
                    continue;
                }
                System.err.println(p + "  " + tar);
                continue;
            }
            System.err.println(p + "  " + tar);
        }
    }

    public ArrayList<Pair<String, String>> alignments() {
        return this.alns;
    }

    public static void main(String[] args) throws Exception {
        String seq = "CGCAGCTGAAGGACTTTCCTGTGTGCGTGAGCACCAAGCCGGAGCACGCG";
        String ref = "";
        NeedlemanWunschLinearGap aa = new NeedlemanWunschLinearGap(seq, ref);
        aa.compute();
    }
}

