/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.bio.seq.align.Motif;
import fork.lib.bio.seq.align.PWMParser;
import fork.lib.math.algebra.advanced.linearalgebra.Matrix;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PWM
extends Motif {
    public static HashMap<Character, Vector> ncvec = new HashMap();
    protected Matrix mat;
    protected double mins = 0.0;
    protected double maxs = 0.0;

    public PWM(Matrix mat) throws Exception {
        this.mat = mat;
        this.init();
    }

    public PWM(ArrayList<Vector> mat) throws Exception {
        this(new Matrix((List<Vector>)mat));
    }

    protected void init() throws Exception {
        for (int i = 0; i < this.mat.columnNumber(); ++i) {
            Vector vec = this.mat.getColumn(i);
            this.mins += vec.toDistribution().min();
            this.maxs += vec.toDistribution().max();
        }
    }

    @Override
    public double align(String seq) throws Exception {
        if (seq.length() != this.mat.columnNumber()) {
            throw new Exception();
        }
        double score = 0.0;
        for (int i = 0; i < seq.length(); ++i) {
            Character c = Character.valueOf(seq.charAt(i));
            Vector vec = ncvec.containsKey(c) ? ncvec.get(c) : new Vector(0.0, 0.0, 0.0, 0.0);
            score += vec.innerProduct(this.mat.getColumn(i));
        }
        double range = this.maxScore() - this.minScore();
        double dif = score > this.minScore() ? score - this.minScore() : 0.0;
        return dif / range;
    }

    public double maxScore() throws Exception {
        return this.maxs;
    }

    public double minScore() throws Exception {
        return this.mins;
    }

    public Matrix getMatrix() {
        return this.mat;
    }

    @Override
    public int length() {
        return this.mat.columnNumber();
    }

    public static void main(String[] args) throws Exception {
        File d = new File("E:\\muxingu\\mystudy\\phd\\files\\test_anal\\motif\\All_PFMs\\1.02\\ALIGNED_ENOLOGO_FORMAT_PFMS");
        File f = new File(d + "/MAL63_136.pfm");
        PWM pw = PWMParser.parseNucleotidePWM(new ReadTable(f).getTable());
        pw.mat.print();
        String seq = "AGCTTTTTTTTTCGC";
        System.out.println(pw.align(seq));
    }

    static {
        try {
            ncvec.put(Character.valueOf('A'), new Vector(1.0, 0.0, 0.0, 0.0));
            ncvec.put(Character.valueOf('T'), new Vector(0.0, 1.0, 0.0, 0.0));
            ncvec.put(Character.valueOf('C'), new Vector(0.0, 0.0, 1.0, 0.0));
            ncvec.put(Character.valueOf('G'), new Vector(0.0, 0.0, 0.0, 1.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

