/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.base.collection.Table;
import fork.lib.bio.seq.align.PWM;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import java.util.ArrayList;
import java.util.List;

public class PWMParser {
    public static PWM parseNucleotidePWM(Table<String> tab) throws Exception {
        ArrayList<Vector> vecs = new ArrayList<Vector>();
        vecs.add(PWMParser.getRowByNucleotide(tab, "A"));
        vecs.add(PWMParser.getRowByNucleotide(tab, "T"));
        vecs.add(PWMParser.getRowByNucleotide(tab, "C"));
        vecs.add(PWMParser.getRowByNucleotide(tab, "G"));
        return new PWM(vecs);
    }

    protected static Vector getRowByNucleotide(Table<String> tab, String tar) throws Exception {
        for (int i = 0; i < tab.rowNumber(); ++i) {
            ArrayList<String> row = tab.getRow(i);
            String nc = row.get(0).toUpperCase();
            if (!nc.equals(tar.toUpperCase())) continue;
            return PWMParser.rowToVec(row);
        }
        return null;
    }

    protected static Vector rowToVec(ArrayList<String> row) throws Exception {
        ArrayList<Double> vs = new ArrayList<Double>();
        for (int i = 1; i < row.size(); ++i) {
            vs.add(Double.parseDouble(row.get(i)));
        }
        return new Vector((List<Double>)vs);
    }
}

