/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.bio.seq.align.Motif;
import fork.lib.bio.seq.align.SequenceScannerParam;
import fork.lib.bio.seq.align.SequenceScannerResult;

public class SequenceScanner {
    protected String seq;
    protected Motif mot;
    protected SequenceScannerResult res = new SequenceScannerResult();
    protected SequenceScannerParam par;

    public SequenceScanner(String seq, Motif mot, SequenceScannerParam par) throws Exception {
        this.seq = seq;
        this.mot = mot;
        this.par = par;
        this.init();
        this.scan();
    }

    public SequenceScanner(String seq, Motif mot) throws Exception {
        this(seq, mot, null);
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = new SequenceScannerParam();
        }
        if (this.seq.length() < this.mot.length()) {
            throw new Exception();
        }
    }

    protected void scan() throws Exception {
        for (int i = 0; i < this.seq.length() - this.mot.length(); ++i) {
            String subs = this.seq.substring(i, i + this.mot.length());
            double score = this.mot.align(subs);
            if (!(score > this.par.thr)) continue;
            this.res.addHit(i, score);
        }
    }

    public SequenceScannerResult getResult() {
        return this.res;
    }
}

