/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.align;

import fork.lib.base.collection.Table;
import fork.lib.bio.seq.align.SubstitutionMatrix;
import java.util.ArrayList;
import java.util.Collection;

public class SubstitutionMatrices {
    public static final char[] AAS = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
    public static final char[] NUCLEOTIDES = new char[]{'A', 'T', 'C', 'G'};

    public static SubstitutionMatrix pam250() {
        char[] cs = AAS;
        double[][] vss = new double[][]{{2.0, -2.0, 0.0, 0.0, -2.0, 0.0, 0.0, 1.0, -1.0, -1.0, -2.0, -1.0, -1.0, -4.0, 1.0, 1.0, 1.0, -6.0, -3.0, 0.0}, {-2.0, 6.0, 0.0, -1.0, -4.0, 1.0, -1.0, -3.0, 2.0, -2.0, -3.0, 3.0, 0.0, -4.0, 0.0, 0.0, -1.0, 2.0, -4.0, -2.0}, {0.0, 0.0, 2.0, 2.0, -4.0, 1.0, 1.0, 0.0, 2.0, -2.0, -3.0, 1.0, -2.0, -4.0, -1.0, 1.0, 0.0, -4.0, -2.0, -2.0}, {0.0, -1.0, 2.0, 4.0, -5.0, 2.0, 3.0, 1.0, 1.0, -2.0, -4.0, 0.0, -3.0, -6.0, -1.0, 0.0, 0.0, -7.0, -4.0, -2.0}, {-2.0, -4.0, -4.0, -5.0, 4.0, -5.0, -5.0, -3.0, -3.0, -2.0, -6.0, -5.0, -5.0, -4.0, -3.0, 0.0, -2.0, -8.0, 0.0, -2.0}, {0.0, 1.0, 1.0, 2.0, -5.0, 4.0, 2.0, -1.0, 3.0, -2.0, -2.0, 1.0, -1.0, -5.0, 0.0, -1.0, -1.0, -5.0, -4.0, -2.0}, {0.0, -1.0, 1.0, 3.0, -5.0, 2.0, 4.0, 0.0, 1.0, -2.0, -3.0, 0.0, -2.0, -5.0, -1.0, 0.0, 0.0, -7.0, -4.0, -2.0}, {1.0, -3.0, 0.0, 1.0, -3.0, -1.0, 0.0, 5.0, -2.0, -3.0, -4.0, -2.0, -3.0, -5.0, -1.0, 1.0, 0.0, -7.0, -5.0, -1.0}, {-1.0, 2.0, 2.0, 1.0, -3.0, 3.0, 1.0, -2.0, 6.0, -2.0, -2.0, 0.0, -2.0, -2.0, 0.0, -1.0, -1.0, -3.0, 0.0, -2.0}, {-1.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -3.0, -2.0, 5.0, 2.0, -2.0, 2.0, 1.0, -2.0, -1.0, 0.0, -5.0, -1.0, 4.0}, {-2.0, -3.0, -3.0, -4.0, -6.0, -2.0, -3.0, -4.0, -2.0, 2.0, 6.0, -3.0, 4.0, 2.0, -3.0, -3.0, -2.0, -2.0, -1.0, 2.0}, {-1.0, 3.0, 1.0, 0.0, -5.0, 1.0, 0.0, -2.0, 0.0, -2.0, -3.0, 5.0, 0.0, -5.0, -1.0, 0.0, 0.0, -3.0, -4.0, -2.0}, {-1.0, 0.0, -2.0, -3.0, -5.0, -1.0, -2.0, -3.0, -2.0, 2.0, 4.0, 0.0, 6.0, 0.0, -2.0, -2.0, -1.0, -4.0, -2.0, 2.0}, {-4.0, -4.0, -4.0, -6.0, -4.0, -5.0, -5.0, -5.0, -2.0, 1.0, 2.0, -5.0, 0.0, 9.0, -5.0, -3.0, -2.0, 0.0, 7.0, -1.0}, {1.0, 0.0, -1.0, -1.0, -3.0, 0.0, -1.0, -1.0, 0.0, -2.0, -3.0, -1.0, -2.0, -5.0, 6.0, 1.0, 0.0, -6.0, -5.0, -1.0}, {1.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 1.0, -1.0, -1.0, -3.0, 0.0, -2.0, -3.0, 1.0, 3.0, 1.0, -2.0, -3.0, -1.0}, {1.0, -1.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, -1.0, 0.0, -2.0, 0.0, -1.0, -2.0, 0.0, 1.0, 3.0, -5.0, -3.0, 0.0}, {-6.0, 2.0, -4.0, -7.0, -8.0, -5.0, -7.0, -7.0, -3.0, -5.0, -2.0, -3.0, -4.0, 0.0, -6.0, -2.0, -5.0, 17.0, 0.0, -6.0}, {-3.0, -4.0, -2.0, -4.0, 0.0, -4.0, -4.0, -5.0, 0.0, -1.0, -1.0, -4.0, -2.0, 7.0, -5.0, -3.0, -3.0, 0.0, 10.0, -2.0}, {0.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0, -2.0, 4.0, 2.0, -2.0, 2.0, -1.0, -1.0, -1.0, 0.0, -6.0, -2.0, 4.0}};
        try {
            return SubstitutionMatrices.toMatrix(cs, vss);
        }
        catch (Exception te) {
            te.printStackTrace();
            return null;
        }
    }

    public static SubstitutionMatrix unitDNAMatrix() {
        char[] cs = NUCLEOTIDES;
        double[][] vss = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        try {
            return SubstitutionMatrices.toMatrix(cs, vss);
        }
        catch (Exception te) {
            te.printStackTrace();
            return null;
        }
    }

    public static SubstitutionMatrix toMatrix(char[] cs, double[][] vss) throws Exception {
        Table<Double> tab = new Table<Double>();
        for (int i = 0; i < vss.length; ++i) {
            ArrayList<Double> al = new ArrayList<Double>();
            double[] vs = vss[i];
            for (int j = 0; j < vs.length; ++j) {
                al.add(vs[j]);
            }
            tab.addRow((Collection<Double>)al);
        }
        ArrayList<Character> rns = SubstitutionMatrices.toCharacters(cs);
        ArrayList cns = (ArrayList)rns.clone();
        return new SubstitutionMatrix(rns, cns, tab);
    }

    private static ArrayList<Character> toCharacters(char[] cs) {
        ArrayList<Character> ret = new ArrayList<Character>();
        for (int i = 0; i < cs.length; ++i) {
            ret.add(new Character(cs[i]));
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        SubstitutionMatrix m = SubstitutionMatrices.pam250();
        Character a = Character.valueOf('M');
        Character b = Character.valueOf('M');
        System.out.println(m.getValueAt(a, b));
    }
}

