/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bar;

import fork.lib.base.format.ByteOp;
import fork.lib.bio.seq.parser.bar.BarHeader;
import fork.lib.bio.seq.parser.bar.BarReader;
import fork.lib.bio.seq.parser.bedgraph.BedGraphExporter;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BarExporter {
    protected LandscapeBuffer lb;
    protected BarHeader head;

    public BarExporter(LandscapeBuffer lb) {
        this(lb, null);
    }

    public BarExporter(LandscapeBuffer lb, BarHeader head) {
        this.lb = lb;
        this.head = head;
        this.init();
    }

    protected void init() {
        if (this.head == null) {
            this.head = BarHeader.defaultBarHeader();
        }
    }

    public BarHeader header() {
        return this.head;
    }

    public void writeToFile(File out) throws IOException {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
        String[] chrs = this.lb.getUnsortedChromosomeList();
        this.head.appendToFile(bos, chrs.length);
        BarExporter.appendToFile(bos, this.lb);
        BarExporter.appendEnd(bos);
    }

    public static void appendToFile(BufferedOutputStream bos, LandscapeBuffer lb) throws IOException {
        String[] chrs = lb.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            int j;
            String chr = chrs[i];
            System.out.println(chr);
            bos.write(ByteOp.intToByteArray(chr.length()));
            bos.write(ByteOp.stringToByteArray(chr));
            bos.write(ByteOp.intToByteArray(0));
            bos.write(ByteOp.intToByteArray(0));
            bos.write(ByteOp.intToByteArray(0));
            ArrayList<Region> rs = lb.getLandscape2DForChromosome(chr).getRegions();
            ArrayList<Integer> ps = new ArrayList<Integer>();
            ArrayList<Float> vs = new ArrayList<Float>();
            int php = Integer.MAX_VALUE;
            for (j = 0; j < rs.size(); ++j) {
                Region r = rs.get(j);
                int l = (int)r.low();
                int h = (int)r.high();
                if (l > php) {
                    ps.add(php);
                    vs.add(Float.valueOf(0.0f));
                }
                ps.add(l);
                vs.add(Float.valueOf(((Double)r.attr()).floatValue()));
                if (j == rs.size() - 1) {
                    ps.add(h + 1);
                    vs.add(Float.valueOf(0.0f));
                }
                php = h + 1;
            }
            bos.write(ByteOp.intToByteArray(ps.size()));
            for (j = 0; j < ps.size(); ++j) {
                bos.write(ByteOp.intToByteArray((Integer)ps.get(j)));
                bos.write(ByteOp.floatToByteArray(((Float)vs.get(j)).floatValue()));
            }
            bos.flush();
        }
    }

    public static void appendEnd(BufferedOutputStream bos) throws IOException {
        bos.write(ByteOp.stringToByteArray("END"));
        bos.close();
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("/home/forksapien/mystudy/phd/test");
        File f = new File(dir + "/test.wig");
        File bar = new File(dir + "/test.bar");
        LandscapeBuilder lb = new BedGraphReader(f).getLandscapeBuilder();
        lb.print();
        System.out.println();
        System.out.println();
        BarExporter bae = new BarExporter(lb);
        bae.header().addParam("sample", "testsample");
        bae.writeToFile(bar);
        BarReader br = new BarReader(bar);
        lb = br.getLandscapeBuilder();
        File t2 = new File(dir + "/test2.wig");
        new BedGraphExporter(lb).writeToFile(t2);
    }
}

