/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bar;

import fork.lib.base.format.ByteOp;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class BarHeader {
    public static String BARR = new String(new char[]{'b', 'a', 'r', 'r', '\r', '\n', '\u001a', '\n'});
    public static int[] DEFAULT_COLTYPES = new int[]{2, 1};
    protected float ver;
    protected int[] colTypes;
    protected int parLen = 0;
    protected HashMap<String, String> pars = new HashMap();

    public BarHeader(float ver, int[] colTypes) {
        this.ver = ver;
        this.colTypes = colTypes;
    }

    public float version() {
        return this.ver;
    }

    public int columnNumber() {
        return this.colTypes.length;
    }

    public int[] columnTypes() {
        return this.colTypes;
    }

    public void addParam(String field, String val) {
        this.pars.put(field, val);
        this.updateParLen();
    }

    protected void updateParLen() {
        this.parLen = this.pars.size();
    }

    public void appendToFile(BufferedOutputStream bos, int nseq) throws IOException {
        bos.write(ByteOp.stringToByteArray(BARR));
        bos.write(ByteOp.floatToByteArray(this.ver));
        bos.write(ByteOp.intToByteArray(nseq));
        bos.write(ByteOp.intToByteArray(this.colTypes.length));
        for (int i = 0; i < this.colTypes.length; ++i) {
            bos.write(ByteOp.intToByteArray(this.colTypes[i]));
        }
        bos.write(ByteOp.intToByteArray(this.parLen));
        for (String field : this.pars.keySet()) {
            String val = this.pars.get(field);
            bos.write(ByteOp.intToByteArray(field.length()));
            bos.write(ByteOp.stringToByteArray(field));
            bos.write(ByteOp.intToByteArray(val.length()));
            bos.write(ByteOp.stringToByteArray(val));
        }
        bos.flush();
    }

    public static BarHeader defaultBarHeader() {
        return new BarHeader(2.0f, DEFAULT_COLTYPES);
    }
}

