/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bar;

import fork.lib.base.format.ByteOp;
import fork.lib.bio.seq.parser.bar.BarExporter;
import fork.lib.bio.seq.parser.bar.BarHeader;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class BarReader
extends LandscapeBuffer {
    protected File f;
    protected BufferedInputStream bi;
    protected BarHeader head;
    protected int nseq;
    protected ArrayList<String> chrs = new ArrayList();
    protected HashSet<String> chrSet = new HashSet();
    protected HashSet<String> checkedChrSet = new HashSet();
    protected BarSequenceReader buffsr;
    protected String curChr;

    public BarReader(File f) throws Exception {
        this.f = f;
        this.init();
    }

    protected void init() throws Exception {
        this.restart();
        for (int i = 0; i < this.nseq; ++i) {
            BarSequenceReader bsr = new BarSequenceReader(null){

                @Override
                protected void doSomething(int p, float v, int pp, float pv) throws Exception {
                }
            };
            String chr = bsr.chr;
            if (this.chrSet.contains(chr)) continue;
            this.chrSet.add(chr);
            this.chrs.add(chr);
        }
        this.restart();
    }

    protected void restart() throws Exception {
        if (this.bi != null) {
            this.bi.close();
        }
        this.bi = new BufferedInputStream(new FileInputStream(this.f));
        this.head = this.readHeader();
        this.buffsr = null;
        this.checkedChrSet = new HashSet();
        this.curChr = null;
    }

    public BarHeader header() {
        return this.head;
    }

    protected BarHeader readHeader() throws Exception {
        String mg = this.nextString(8);
        if (!mg.equals(BarHeader.BARR)) {
            throw new Exception();
        }
        float ver = this.nextFloat();
        this.nseq = this.nextInt();
        int ncol = this.nextInt();
        int[] colTypes = new int[ncol];
        for (int i = 0; i < ncol; ++i) {
            int v;
            colTypes[i] = v = this.nextInt();
        }
        BarHeader ret = new BarHeader(ver, colTypes);
        int parlen = this.nextInt();
        for (int i = 0; i < parlen; ++i) {
            String s = this.nextString(this.nextInt());
            String s2 = this.nextString(this.nextInt());
            ret.addParam(s, s2);
        }
        return ret;
    }

    @Override
    public String[] getChromosomeList() {
        Object[] cs = this.getUnsortedChromosomeList();
        Arrays.sort(cs);
        return cs;
    }

    @Override
    public String[] getUnsortedChromosomeList() {
        String[] ret = new String[this.chrs.size()];
        return this.chrs.toArray(ret);
    }

    @Override
    public boolean containsChromosome(String chr) {
        return this.chrSet.contains(chr);
    }

    @Override
    public Landscape2D getLandscape2DForChromosome(String chrTar) {
        if (chrTar == null) {
            return new Landscape2D();
        }
        try {
            String chr;
            if (this.checkedChrSet.contains(chrTar)) {
                this.restart();
            }
            if (chrTar.equals(this.curChr)) {
                return this.add(this.buffsr, chrTar);
            }
            do {
                this.buffsr = new BarSequenceReader(new LandscapeBuilder());
                chr = this.buffsr.chr;
                System.out.println(chr + "  " + chrTar);
                this.curChr = chr;
                if (this.checkedChrSet.contains(chr)) continue;
                this.checkedChrSet.add(chr);
            } while (!chrTar.equals(chr));
            return this.add(this.buffsr, chrTar);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Landscape2D add(BarSequenceReader buffsr, String chrTar) throws Exception {
        buffsr.lb.removeDuplicate();
        buffsr.lb.sortAll();
        return buffsr.lb.getLandscape2DForChromosome(chrTar);
    }

    public LandscapeBuilder getLandscapeBuilder() throws Exception {
        LandscapeBuilder lb = new LandscapeBuilder();
        this.bi = new BufferedInputStream(new FileInputStream(this.f));
        this.head = this.readHeader();
        for (int i = 0; i < this.nseq; ++i) {
            BarSequenceReader barSequenceReader = new BarSequenceReader(lb);
        }
        lb.removeDuplicate();
        lb.sortAll();
        return lb;
    }

    protected byte[] nextByteArray(int len) throws IOException {
        byte[] b = new byte[len];
        this.bi.read(b);
        return b;
    }

    protected int nextInt() throws IOException {
        return ByteOp.byteArrayToInt(this.nextByteArray(4));
    }

    protected char[] nextCharArray(int len) throws IOException {
        return ByteOp.byteArrayToCharArray(this.nextByteArray(len));
    }

    protected String nextString(int len) throws IOException {
        return new String(this.nextByteArray(len));
    }

    protected char nextChar() throws IOException {
        return (char)this.bi.read();
    }

    protected float nextFloat() throws IOException {
        return ByteOp.byteArrayToFloatBigEndian(this.nextByteArray(4));
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("/home/forksapien/mystudy/phd/files");
        File d = new File(dir + "/other_datasets/lee_2007");
        File f = new File(d + "/analyzed_data_complete_bw20.bar");
        f = new File(dir + "/chip/chip/bulk_HTZ1_anti660/04112011_anti660HTZ1_pvalue.bar");
        BedGraphReader br = new BedGraphReader(new File(dir + "/data/chip/norm/norm_htz1.wig"));
        new BarExporter(br.getLandscapeBuilder()).writeToFile(new File("/home/forksapien/mystudy/phd/files/test/norm_htz1_test.bar"));
    }

    class BarSequenceReader {
        public String chr = "";
        public LandscapeBuilder lb;

        public BarSequenceReader(LandscapeBuilder lb) throws Exception {
            this.lb = lb;
            this.init();
        }

        protected void init() throws Exception {
            String s;
            this.chr = "";
            for (int i = 0; i < 3; ++i) {
                byte[] ba = BarReader.this.nextByteArray(4);
                if (new String(ba).equals("END\n")) {
                    return;
                }
                int a = ByteOp.byteArrayToInt(ba);
                s = BarReader.this.nextString(a);
                if (i != 0) continue;
                this.chr = s;
            }
            int np = BarReader.this.nextInt();
            for (int i = 0; i < np; ++i) {
                s = BarReader.this.nextString(BarReader.this.nextInt());
                s = BarReader.this.nextString(BarReader.this.nextInt());
            }
            int nd = BarReader.this.nextInt();
            int pp = -1;
            float pv = 0.0f;
            for (int i = 0; i < nd; ++i) {
                int p = BarReader.this.nextInt();
                float v = BarReader.this.nextFloat();
                this.doSomething(p, v, pp, pv);
                pp = p;
                pv = v;
            }
        }

        protected void doSomething(int p, float v, int pp, float pv) throws Exception {
            if (pp != -1 && p > pp && v != 0.0f) {
                Region r = new Region(pp, p - 1);
                r.setAttribute(new Double(pv));
                this.lb.addNoCheckOrder(this.chr, r);
            }
        }
    }
}

