/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bed;

import fork.lib.base.collection.Table;
import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.bio.seq.parser.bed.BedReaderParam;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class BedReader {
    public static final int chrInd = 0;
    public static final int lowInd = 1;
    public static final int highInd = 2;
    public static final int idInd = 3;
    public static final int valInd = 4;
    public static final int strandInd = 5;
    protected File bed;
    protected GenomicRegionsBuilder gb = new GenomicRegionsBuilder();
    protected BedReaderParam par;

    public BedReader(File bed, BedReaderParam par) throws Exception {
        this.bed = bed;
        this.par = par;
        this.init();
    }

    public BedReader(File bed) throws Exception {
        this(bed, null);
    }

    public BedReader(String path) throws Exception {
        this(new File(path));
    }

    public BedReader(String path, BedReaderParam par) throws Exception {
        this(new File(path), par);
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = new BedReaderParam();
        }
        ReadTable rt = new ReadTable(this.bed);
        rt.setParam(this.par.tablePar);
        Table<String> t = rt.getTable();
        for (int i = 0; i < t.rowNumber(); ++i) {
            GenomicRegion gr;
            String std;
            ArrayList<String> r = t.getRow(i);
            String chr = r.get(0);
            int low = Integer.parseInt(r.get(1));
            int high = Integer.parseInt(r.get(2)) - 1;
            try {
                std = r.get(5);
            }
            catch (Exception e) {
                std = ".";
            }
            GenomicRegion genomicRegion = gr = this.par.ifDirectional ? new DirectionalGenomicRegion(chr, std.charAt(0), low, high) : new GenomicRegion(chr, low, high);
            if (this.par.ifDirectional) {
                String fa = null;
                String fb = null;
                try {
                    fa = r.get(3);
                    fb = r.get(4);
                }
                catch (Exception e) {
                    fa = "";
                    fb = "0";
                }
                gr.setID(fa);
                try {
                    gr.setValue(Double.parseDouble(fb));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.par.ifReadExtension) {
                String s = "";
                for (int j = 6; j < r.size(); ++j) {
                    s = s + r.get(j);
                    if (j >= r.size() - 1) continue;
                    s = s + "\t";
                }
                gr.setAttribute(s);
            }
            this.gb.add(gr);
        }
        this.gb.sortAll();
    }

    public GenomicRegionsBuilder getGenomicRegionsBuilder() {
        return this.gb;
    }

    public HashMap<String, GenomicRegion> getIDToRegionMap() {
        HashMap<String, GenomicRegion> ret = new HashMap<String, GenomicRegion>();
        for (GenomicRegion gr : this.gb) {
            ret.put(gr.getID(), gr);
        }
        return ret;
    }
}

