/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bed;

import fork.lib.bio.seq.parser.bed.BedAttribute;
import fork.lib.bio.seq.parser.bed.BedWriterParam;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.math.algebra.elementary.number.RealNumber;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;

public class BedWriter {
    protected GenomicRegionsBuilder gb;
    protected BedWriterParam par;

    public BedWriter(GenomicRegionsBuilder gb, BedWriterParam par) {
        this.gb = gb;
        this.par = par;
        this.init();
    }

    public BedWriter(GenomicRegionsBuilder gb) {
        this(gb, null);
    }

    protected void init() {
        if (this.par == null) {
            this.par = new BedWriterParam();
        }
    }

    public BedWriterParam param() {
        return this.par;
    }

    public void writeToFile(String out) throws Exception {
        this.writeToFile(new File(out));
    }

    public void writeToFile(File out) throws Exception {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        if (!this.par.head.isEmpty()) {
            for (String h : this.par.head) {
                bw.write(h + "\n");
            }
        }
        for (GenomicRegion gr : this.gb) {
            bw.write(gr.toBedFormat());
            if (this.par.ifDirectional) {
                String exp;
                bw.write("\t" + this.column3(gr));
                bw.write("\t" + this.column4(gr));
                bw.write("\t" + this.column5(gr));
                if (this.par.ifExpanded && (exp = this.column6On(gr)) != null && !exp.equals("")) {
                    bw.write("\t" + exp);
                }
            }
            bw.write("\n");
        }
        bw.close();
    }

    protected String column3(GenomicRegion gr) throws Exception {
        if (gr.getID() != null && !gr.getID().equals("")) {
            return gr.getID();
        }
        if (gr.attr() == null || !(gr.attr() instanceof BedAttribute)) {
            return gr.toUCSCFormat();
        }
        String ret = gr.getID();
        if (ret == null) {
            return gr.toUCSCFormat();
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    protected String column4(GenomicRegion gr) throws Exception {
        Double b;
        block6: {
            if (gr.attr() == null || !(gr.attr() instanceof BedAttribute)) {
                return RealNumber.intOrDoubleToString(gr.getValue(), this.par.df);
            }
            b = gr.getValue();
            if (b != null) break block6;
            return "0";
            {
                catch (NumberFormatException ne) {
                    return null;
                }
            }
        }
        try {
            return RealNumber.intOrDoubleToString(b, this.par.df);
        }
        catch (NumberFormatException ne2) {
            return "0";
        }
    }

    protected String column5(GenomicRegion gr) throws Exception {
        if (gr instanceof DirectionalGenomicRegion) {
            return Character.toString(((DirectionalGenomicRegion)gr).strand());
        }
        return ".";
    }

    protected String column6On(GenomicRegion gr) throws Exception {
        Object o = gr.attr();
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof List) {
            StringBuilder sb = new StringBuilder();
            List ol = (List)o;
            for (int i = 0; i < ol.size(); ++i) {
                sb.append(ol.get(i).toString());
                if (i == ol.size() - 1) continue;
                sb.append("\t");
            }
            return sb.toString();
        }
        return "";
    }
}

