/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bedgraph;

import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class BedGraphBuffer
extends LandscapeBuffer {
    protected File file;
    protected String tit;
    protected ArrayList<String> chrs = new ArrayList();
    protected HashSet<String> chrSet = new HashSet();
    protected BufferedReader br;
    protected HashSet<String> checkedChrSet = new HashSet();
    protected String buffLine;
    protected String curChr;

    public BedGraphBuffer(File file) throws Exception {
        this.file = file;
        this.init();
    }

    private void init() throws Exception {
        String l;
        BufferedReader _br = new BufferedReader(new FileReader(this.file));
        this.tit = _br.readLine();
        System.out.print("loading....  ");
        while ((l = _br.readLine()) != null) {
            String chr = this.getChr(l);
            if (this.chrSet.contains(chr)) continue;
            this.chrSet.add(chr);
            this.chrs.add(chr);
        }
        this.restart();
        System.out.println("loaded!");
    }

    protected String getChr(String l) {
        return l.substring(0, l.indexOf("\t"));
    }

    protected void restart() throws IOException {
        if (this.br != null) {
            this.br.close();
        }
        this.br = new BufferedReader(new FileReader(this.file));
        this.br.readLine();
        this.checkedChrSet = new HashSet();
        this.buffLine = null;
        this.curChr = null;
    }

    public void close() throws IOException {
        this.br.close();
    }

    public String getTitle() {
        return this.tit;
    }

    @Override
    public String[] getChromosomeList() {
        Object[] cs = this.getUnsortedChromosomeList();
        Arrays.sort(cs);
        return cs;
    }

    @Override
    public String[] getUnsortedChromosomeList() {
        String[] ret = new String[this.chrs.size()];
        return this.chrs.toArray(ret);
    }

    @Override
    public boolean containsChromosome(String chr) {
        return this.chrSet.contains(chr);
    }

    @Override
    public Landscape2D getLandscape2DForChromosome(String chrTar) {
        if (chrTar == null) {
            return new Landscape2D();
        }
        try {
            String chr;
            Landscape2D ld = new Landscape2D();
            if (this.checkedChrSet.contains(chrTar)) {
                this.restart();
            }
            if (chrTar.equals(this.curChr)) {
                this.add(ld, this.buffLine);
            }
            do {
                this.buffLine = this.br.readLine();
                if (this.buffLine == null) break;
                this.curChr = chr = this.getChr(this.buffLine);
                if (!this.checkedChrSet.contains(chr)) {
                    this.checkedChrSet.add(chr);
                }
                if (!chrTar.equals(chr)) continue;
                this.add(ld, this.buffLine);
            } while (chr.equals(this.curChr));
            return ld;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void add(Landscape2D ld, String l) throws Exception {
        String[] ss = l.split("\t");
        Region r = new Region(Integer.parseInt(ss[1]), Integer.parseInt(ss[2]) - 1);
        r.setAttribute(Double.parseDouble(ss[3]));
        ld.add(r);
    }
}

