/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bedgraph;

import fork.lib.base.file.FileName;
import fork.lib.bio.seq.parser.bedgraph.BedGraphExporterParam;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class BedGraphExporter {
    protected LandscapeBuffer lb;
    protected BedGraphExporterParam par;

    public BedGraphExporter(LandscapeBuffer lb) throws Exception {
        this(lb, new BedGraphExporterParam());
    }

    public BedGraphExporter(LandscapeBuffer lb, BedGraphExporterParam par) throws Exception {
        this.lb = lb;
        this.par = par;
    }

    public BedGraphExporter(LandscapeBuffer lb, String tit) throws Exception {
        this.lb = lb;
        this.par = new BedGraphExporterParam();
        this.par.tit = tit;
        this.init();
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = new BedGraphExporterParam();
        }
    }

    protected String format(double v) {
        return this.par.df.format(v);
    }

    public BedGraphExporterParam param() {
        return this.par;
    }

    public void appendToFile(Writer bw) throws IOException {
        String[] chrs = this.lb.getChromosomeList();
        for (int j = 0; j < chrs.length; ++j) {
            String chr = chrs[j];
            ArrayList<Region> rs = this.lb.getLandscape2DForChromosome(chr).getRegions();
            if (rs == null || rs.size() < 1) continue;
            for (int i = 0; i < rs.size(); ++i) {
                Region r = rs.get(i);
                double v = (Double)r.attr();
                if (v == 0.0) continue;
                bw.write(chr + "\t" + (int)r.low() + "\t" + (int)(r.high() + 1.0) + "\t" + this.format(v) + "\n");
            }
        }
    }

    public static void writeTitle(BufferedWriter bw, String tit) throws IOException {
        bw.write("track type=bedGraph name=\"" + tit + "\"\n");
    }

    public void writeToFile(File out) throws IOException {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        String tit = this.par.tit.equals("") ? FileName.baseName(out) : this.par.tit;
        BedGraphExporter.writeTitle(bw, tit);
        this.appendToFile(bw);
        bw.close();
    }

    public void writeToFile(String out) throws IOException {
        this.writeToFile(new File(out));
    }
}

