/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bedgraph;

import fork.lib.base.file.FileName;
import fork.lib.bio.seq.parser.bedgraph.BedGraphExporter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;

public class BedGraphMerger {
    protected HashMap<String, HashMap<Integer, Double>> map = new HashMap();

    public BedGraphMerger() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
    }

    public void appendFile(File f) throws Exception {
        String l;
        System.out.println(f);
        BufferedReader br = new BufferedReader(new FileReader(f));
        br.readLine();
        while ((l = br.readLine()) != null) {
            HashMap<Integer, Double> mt;
            String[] ss = l.split("\t");
            String chr = ss[0];
            int low = Integer.parseInt(ss[1]);
            int high = Integer.parseInt(ss[2]);
            double freq = Double.parseDouble(ss[3]);
            if (!this.map.containsKey(chr)) {
                this.map.put(chr, new HashMap());
            }
            if (!(mt = this.map.get(chr)).containsKey(low)) {
                mt.put(low, 0.0);
            }
            mt.put(low, mt.get(low) + freq);
            if (!mt.containsKey(high)) {
                mt.put(high, 0.0);
            }
            mt.put(high, mt.get(high) - freq);
        }
        br.close();
    }

    public void writeToFile(File out) throws Exception {
        this.writeToFile(out, FileName.baseName(out), new DecimalFormat("#.##"));
    }

    public void writeToFile(File out, String tag, DecimalFormat df) throws Exception {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        BedGraphExporter.writeTitle(bw, tag);
        Object[] chrs = new String[this.map.keySet().size()];
        this.map.keySet().toArray(chrs);
        Arrays.sort(chrs);
        for (int i = 0; i < chrs.length; ++i) {
            Object chr = chrs[i];
            HashMap<Integer, Double> mt = this.map.get(chr);
            Object[] ks = new Integer[mt.keySet().size()];
            mt.keySet().toArray(ks);
            Arrays.sort(ks);
            int cval = 0;
            int prev = -1;
            for (int j = 0; j < ks.length; ++j) {
                double testv;
                int k = (Integer)ks[j];
                double v = mt.get(k);
                if (prev != -1 && (testv = Double.parseDouble(df.format(cval))) != 0.0) {
                    bw.write((String)chr + "\t" + Integer.toString(prev) + "\t" + Integer.toString(k) + "\t" + df.format(cval) + "\n");
                }
                cval = (int)((double)cval + v);
                prev = k;
            }
        }
        bw.close();
    }
}

