/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bedgraph;

import fork.lib.base.file.FileName;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class BedGraphReader {
    protected boolean iftit = true;
    protected File file;
    protected LandscapeBuilder lb = new LandscapeBuilder();
    protected String tit;

    public BedGraphReader(File file) throws Exception {
        this.file = file;
        this.init();
    }

    public BedGraphReader(String path) throws Exception {
        this(new File(path));
    }

    private void init() throws Exception {
        String l;
        BufferedReader br;
        BufferedReader bufferedReader = br = FileName.extension(this.file).equals("gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.file)), "UTF-8")) : new BufferedReader(new FileReader(this.file));
        while ((l = br.readLine()) != null) {
            Double v;
            String[] ss;
            if (l.indexOf("#") == 0) continue;
            if (this.iftit) {
                try {
                    ss = l.split("\t");
                    v = Double.parseDouble(ss[3]);
                    this.iftit = false;
                }
                catch (Exception e) {
                    this.tit = l;
                    continue;
                }
            }
            if ((v = Double.valueOf(Double.parseDouble((ss = l.split("\t"))[3]))) == 0.0) continue;
            Region r = new Region(Double.parseDouble(ss[1]), Double.parseDouble(ss[2]) - 1.0);
            r.setAttribute(new Double(v));
            this.lb.add(ss[0], r);
        }
        br.close();
        this.lb.sortAll();
    }

    public String getTitle() {
        return this.tit;
    }

    public LandscapeBuilder getLandscapeBuilder() {
        return this.lb;
    }
}

