/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.bedgraph;

import fork.lib.base.file.FileName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;

public class BedGraphSplitter {
    private boolean ifskip = true;
    private String file;
    private String tag;
    private File tempdir;
    private HashMap<String, File> chrf = new HashMap();
    private HashMap<String, BufferedWriter> chrbw = new HashMap();

    public BedGraphSplitter(String file) {
        this.file = file;
        this.tag = FileName.baseName(file);
        this.tempdir = new File(new File(file).getAbsoluteFile().getParentFile() + "/temp_" + this.tag);
        this.tempdir.mkdirs();
    }

    public void start() throws Exception {
        String l;
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        while ((l = br.readLine()) != null) {
            if (this.ifskip) {
                if (l.charAt(0) == '#') continue;
                this.ifskip = false;
                continue;
            }
            String chr = l.split("\t")[0];
            if (!this.chrbw.containsKey(chr)) {
                File f = new File(this.tempdir + "/" + chr + "_" + this.tag + ".bedgraph");
                this.chrf.put(chr, f);
                this.chrbw.put(chr, new BufferedWriter(new FileWriter(f)));
            }
            this.chrbw.get(chr).write(l + "\n");
        }
        br.close();
        for (String chr : this.chrbw.keySet()) {
            this.chrbw.get(chr).close();
        }
    }

    public void removeAll() {
        for (String chr : this.chrf.keySet()) {
            this.chrf.get(chr).delete();
        }
        this.tempdir.delete();
    }

    public HashMap<String, File> chromosomeFiles() {
        return this.chrf;
    }

    public File getFileForChromosome(String chr) {
        return this.chrf.get(chr);
    }

    public static void main(String[] args) throws Exception {
        String f = "C:\\muxingu\\data\\inhouse\\yanzi\\20180301_kat7\\other_histmods\\bedgraph/Gilan_DMSO_BRD4_grch38.bedgraph";
        BedGraphSplitter ss = new BedGraphSplitter(f);
        ss.start();
    }
}

