/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.fasta;

import fork.lib.base.file.io.txt.ChunkEntry;
import fork.lib.base.file.io.txt.ChunkReader;
import fork.lib.base.file.io.txt.DefaultChunkReaderParam;
import fork.lib.bio.seq.parser.fasta.FastaEntry;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class FastaReader
implements Closeable {
    public static final String IND = ">";
    protected ChunkReader mr;

    public FastaReader(String path) throws Exception {
        this(path, false);
    }

    public FastaReader(File file) throws Exception {
        this(file.getAbsolutePath());
    }

    public FastaReader(String path, boolean ifgz) throws Exception {
        DefaultChunkReaderParam par = new DefaultChunkReaderParam();
        par.marks.add(Character.valueOf('>'));
        this.mr = new ChunkReader(path, ifgz, par);
    }

    public FastaEntry nextEntry() throws Exception {
        ChunkEntry en = this.mr.nextEntry();
        if (en == null) {
            return null;
        }
        return new FastaEntry(en.getChunk());
    }

    public static boolean isTitleLine(String l) {
        if (l == null) {
            return true;
        }
        return l.contains(IND);
    }

    public static String getTitle(String l) {
        return l.substring(l.indexOf(IND) + IND.length());
    }

    @Override
    public void close() throws IOException {
        this.mr.close();
    }

    public ArrayList<String> getAlSequences() throws Exception {
        FastaEntry en;
        ArrayList<String> ret = new ArrayList<String>();
        while ((en = this.nextEntry()) != null) {
            ret.add(en.sequence());
        }
        return ret;
    }
}

