/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.fasta;

import fork.lib.bio.seq.parser.fasta.FastaEntry;
import fork.lib.bio.seq.parser.fasta.FastaWriterParam;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class FastaWriter
implements Closeable {
    protected Writer bw;
    protected FastaWriterParam par;

    public FastaWriter(BufferedWriter bw) {
        this(bw, null);
    }

    public FastaWriter(BufferedWriter bw, FastaWriterParam par) {
        this.bw = bw;
        this.par = par;
        if (this.par == null) {
            this.par = new FastaWriterParam();
        }
    }

    public FastaWriter(String path, boolean ifgz, FastaWriterParam par) throws IOException {
        new File(path).getAbsoluteFile().getParentFile().mkdirs();
        this.bw = ifgz ? new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(path)), "UTF-8") : new BufferedWriter(new FileWriter(path));
        this.par = par;
        if (this.par == null) {
            this.par = new FastaWriterParam();
        }
    }

    public FastaWriter(File out) throws IOException {
        this(out.getAbsolutePath(), false);
    }

    public FastaWriter(File out, boolean ifgz) throws IOException {
        this(out.getAbsolutePath(), ifgz);
    }

    public FastaWriter(String path) throws IOException {
        this(path, false);
    }

    public FastaWriter(String path, boolean ifgz) throws IOException {
        this(path, ifgz, null);
    }

    public FastaWriterParam param() {
        return this.par;
    }

    public void write(FastaEntry e) throws Exception {
        if (this.par.charPerLine <= 0) {
            this.par.charPerLine = Integer.MAX_VALUE;
        }
        this.bw.write(">" + e.tit + "\n");
        String s = e.seq;
        int ind = 1;
        boolean nl = false;
        for (int j = 0; j < s.length(); ++j) {
            this.bw.write(s.charAt(j));
            nl = false;
            if (this.par.ifNewLine && ind >= this.par.charPerLine) {
                ind = 0;
                this.bw.write("\n");
                nl = true;
            }
            ++ind;
        }
        if (!nl) {
            this.bw.write("\n");
        }
    }

    @Override
    public void close() throws IOException {
        this.bw.close();
    }
}

