/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.fastq;

import fork.lib.base.file.FileName;
import fork.lib.bio.seq.parser.fastq.FastqEntry;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class FastqReader {
    protected BufferedReader br;

    public FastqReader(String f, boolean ifgz) throws Exception {
        if (ifgz) {
            InputStreamReader decoder = new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(f)), "UTF-8");
            this.br = new BufferedReader(decoder);
        } else {
            this.br = new BufferedReader(new FileReader(f));
        }
    }

    public FastqReader(String path) throws Exception {
        this(path, FileName.extension(path).equals("gz") || FileName.extension(path).equals("gzip"));
    }

    public FastqEntry nextEntry() {
        try {
            String line = this.br.readLine();
            if (line == null) {
                return null;
            }
            return new FastqEntry(line.substring(1), this.br.readLine(), this.br.readLine(), this.br.readLine());
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void close() throws IOException {
        this.br.close();
    }
}

