/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.fastq;

import fork.lib.bio.seq.parser.fastq.FastqEntry;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class FastqWriter
implements Closeable {
    protected Writer bw;

    public FastqWriter(BufferedWriter bw) {
        this.bw = bw;
    }

    public FastqWriter(String path, boolean ifgzip) throws IOException {
        new File(path).getAbsoluteFile().getParentFile().mkdirs();
        this.bw = ifgzip ? new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(path)), "UTF-8") : new BufferedWriter(new FileWriter(path));
    }

    public FastqWriter(String path) throws IOException {
        this(path, false);
    }

    public void write(FastqEntry e) throws Exception {
        this.bw.write('@' + e.ID() + "\n");
        this.bw.write(e.sequence() + "\n");
        this.bw.write(e.comment() + "\n");
        this.bw.write(e.qualiy() + "\n");
    }

    @Override
    public void close() throws IOException {
        try {
            this.bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

