/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.gtfgff;

import fork.lib.bio.seq.parser.gtfgff.GtfLine;
import fork.lib.bio.seq.region.Gene;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.Transcript;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class GtfFilter {
    protected HashMap<Filter, Filter> filtmap = new HashMap();

    public void addGeneTranscriptFilter(Filter gfilt, Filter trfilt) {
        this.filtmap.put(gfilt, trfilt);
    }

    public GenomicRegionsBuilder apply(GenomicRegionsBuilder gb) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (GenomicRegion gr : gb) {
            Gene gene = (Gene)gr;
            GtfLine gl = (GtfLine)gene.attr();
            Filter genefilt = null;
            for (Filter gfilt : this.filtmap.keySet()) {
                if (!gfilt.satisfies(gl)) continue;
                genefilt = gfilt;
                break;
            }
            if (genefilt == null) continue;
            Filter trfilt = this.filtmap.get(genefilt);
            ArrayList<Transcript> trs = new ArrayList<Transcript>();
            for (Transcript tr : gene.children()) {
                if (!trfilt.satisfies((GtfLine)tr.attr())) continue;
                trs.add(tr);
            }
            if (trs.isEmpty()) continue;
            Gene ng = new Gene(gene.chr(), gene.strand(), trs);
            ng.setAttribute(gene.attr());
            ng.setID(gene.getID());
            ng.setValue(gene.getValue());
            ret.add(ng);
        }
        return ret;
    }

    public static GtfFilter proteinCoding() {
        GtfFilter gf = new GtfFilter();
        gf.addGeneTranscriptFilter(new Filter(GtfLine.FIELD_GENE_BIOTYPE, true, "protein_coding"), new Filter(GtfLine.FIELD_TRANSCRIPT_BIOTYPE, true, "protein_coding"));
        return gf;
    }

    public static GtfFilter proteinCodingAndPseudogene() {
        GtfFilter gf = new GtfFilter();
        gf.addGeneTranscriptFilter(new Filter(GtfLine.FIELD_GENE_BIOTYPE, true, "protein_coding"), new Filter(GtfLine.FIELD_TRANSCRIPT_BIOTYPE, true, "protein_coding"));
        gf.addGeneTranscriptFilter(new Filter(GtfLine.FIELD_GENE_BIOTYPE, true, "pseudogene"), new Filter(GtfLine.FIELD_TRANSCRIPT_BIOTYPE, false, ""));
        return gf;
    }

    public static class Filter {
        HashMap<String, HashSet<String>> filt = new HashMap();
        HashMap<String, Boolean> includeMode = new HashMap();

        public Filter() {
        }

        public Filter(String field, boolean mode, String ... vals) {
            this.addFilter(field, mode, vals);
        }

        public void addFilter(String field, boolean mode, String ... vals) {
            if (!this.filt.containsKey(field)) {
                this.filt.put(field, new HashSet());
            }
            this.setMode(field, mode);
            for (String val : vals) {
                this.filt.get(field).add(val);
            }
        }

        public void setMode(String field, boolean boo) {
            this.includeMode.put(field, boo);
        }

        public boolean inclusionMode(String field) {
            if (!this.includeMode.containsKey(field)) {
                return true;
            }
            return this.includeMode.get(field);
        }

        public boolean satisfies(GtfLine gl) {
            for (String fdkey : this.filt.keySet()) {
                String fv = gl.getField(fdkey);
                HashSet<String> valid = this.filt.get(fdkey);
                boolean inc = this.inclusionMode(fdkey);
                if (!(inc ? !valid.contains(fv) : valid.contains(fv))) continue;
                return false;
            }
            return true;
        }
    }
}

