/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.gtfgff;

import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class GtfGffLine {
    public static int col_chr = 0;
    public static int col_source = 1;
    public static int col_feature = 2;
    public static int col_low = 3;
    public static int col_high = 4;
    public static int col_5 = 5;
    public static int col_std = 6;
    public static int col_7 = 7;
    public static int col_fields = 8;
    public static String SEP = "\t";
    public static String SEP_FIELD = ";";
    public static String SEP_QUOTE = "\"";
    protected String[] fds;
    protected HashMap<String, String> fieldMap = new HashMap();
    protected ArrayList<String> fieldKeys = new ArrayList();

    public GtfGffLine(String line) {
        this(line, true);
    }

    public GtfGffLine(String line, boolean iffields) {
        this(line.split(SEP), iffields);
    }

    public GtfGffLine(String[] ss, boolean iffields) {
        this.fds = new String[]{ss[col_chr], ss[col_source], ss[col_feature], ss[col_low], ss[col_high], ss[col_std], ss.length - 1 >= col_fields ? ss[col_fields] : ""};
        this.initFields();
    }

    public GtfGffLine(DirectionalGenomicRegion dr, String feat, String source) {
        this.fds = new String[]{dr.chr(), source, feat, Integer.toString((int)dr.low()), Integer.toString((int)dr.high()), ".", Character.toString(dr.strand()), ".", ""};
    }

    public String chr() {
        return this.fds[0];
    }

    public String source() {
        return this.fds[1];
    }

    public String feature() {
        return this.fds[2];
    }

    public int low() {
        return Integer.parseInt(this.fds[3]);
    }

    public int high() {
        return Integer.parseInt(this.fds[4]);
    }

    public char strand() {
        return this.fds[5].charAt(0);
    }

    public String fields() {
        return this.fds[6];
    }

    public void setChr(String chr) {
        this.fds[0] = chr;
    }

    public void setSource(String source) {
        this.fds[1] = source;
    }

    public void setFeature(String feature) {
        this.fds[2] = feature;
    }

    public void setLow(int low) {
        this.fds[3] = Integer.toString(low);
    }

    public void setHigh(int high) {
        this.fds[4] = Integer.toString(high);
    }

    public void setStrand(char std) {
        this.fds[5] = Character.toString(std);
    }

    public ArrayList<String> fieldKeys() {
        return this.fieldKeys;
    }

    public HashMap<String, String> fieldMap() {
        return this.fieldMap;
    }

    public String getField(String tag) {
        return this.fieldMap.get(tag);
    }

    public void setField(String f, String k) {
        this.fieldMap.put(f, k);
        if (!this.fieldKeys.contains(f)) {
            this.fieldKeys.add(f);
        }
    }

    public void removeField(String f) {
        if (this.fieldMap.containsKey(f)) {
            this.fieldMap.remove(f);
            this.fieldKeys.remove(f);
        }
    }

    public void removeAllFields() {
        this.fieldMap = new HashMap();
        this.fieldKeys = new ArrayList();
    }

    protected abstract void initFields();
}

