/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.gtfgff;

import fork.lib.bio.seq.parser.gtfgff.GtfGffLine;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;

public class GtfLine
extends GtfGffLine
implements Cloneable {
    public static String FEATURE_GENE = "gene";
    public static String FEATURE_TRANSCRIPT = "transcript";
    public static String FEATURE_EXON = "exon";
    public static String FEATURE_CDS = "CDS";
    public static String FEATURE_START_CODON = "start_codon";
    public static String FEATURE_STOP_CODON = "stop_codon";
    public static String FIELD_GENE_ID = "gene_id";
    public static String FIELD_GENE_NAME = "gene_name";
    public static String FIELD_GENE_BIOTYPE = "gene_biotype";
    public static String FIELD_TRANSCRIPT_ID = "transcript_id";
    public static String FIELD_TRANSCRIPT_BIOTYPE = "transcript_biotype";
    public static String FIELD_EXON_ID = "exon_id";

    public GtfLine(String line) {
        super(line);
    }

    public GtfLine(String line, boolean iffields) {
        super(line, iffields);
    }

    public GtfLine(String[] ss, boolean iffields) {
        super(ss, iffields);
    }

    public GtfLine(DirectionalGenomicRegion dr, String feat, String source) {
        super(dr, feat, source);
    }

    @Override
    protected void initFields() {
        String[] ss = this.fds[6].split(SEP_FIELD);
        for (int i = 0; i < ss.length; ++i) {
            int ind;
            String fd = ss[i];
            if (fd.replace(" ", "").equals("")) continue;
            for (ind = 0; ind < fd.length() && fd.charAt(ind) == ' '; ++ind) {
            }
            fd = fd.substring(ind);
            String[] schk = fd.split(" ");
            String key = schk[0].replace(" ", "").replace(SEP_QUOTE, "");
            String val = schk[1].replace(" ", "").replace(SEP_QUOTE, "");
            this.fieldKeys.add(key);
            this.fieldMap.put(key, val);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.chr()).append(SEP);
        sb.append(this.source()).append(SEP);
        sb.append(this.feature()).append(SEP);
        sb.append(Integer.toString(this.low())).append(SEP);
        sb.append(Integer.toString(this.high())).append(SEP);
        sb.append('.').append(SEP);
        sb.append(this.strand()).append(SEP);
        sb.append('.').append(SEP);
        for (String k : this.fieldKeys) {
            sb.append(k).append(' ').append(SEP_QUOTE).append((String)this.fieldMap.get(k)).append(SEP_QUOTE).append(SEP_FIELD).append(' ');
        }
        return sb.toString();
    }

    public GtfLine clone() throws CloneNotSupportedException {
        return (GtfLine)super.clone();
    }
}

