/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.gtfgff;

import fork.lib.bio.seq.parser.gtfgff.GtfLine;
import fork.lib.bio.seq.parser.gtfgff.GtfReaderParam;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.Gene;
import fork.lib.bio.seq.region.Transcript;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class GtfReader {
    private GtfReaderParam par;
    protected File f;
    protected BufferedReader br;
    protected ArrayList<GtfLine> buff = new ArrayList();
    protected GenomicRegionsBuilder gb = new GenomicRegionsBuilder();
    private boolean ifStart = false;

    public GtfReader(File f, GtfReaderParam par) throws Exception {
        this.f = f;
        this.init();
    }

    public GtfReader(File f) throws Exception {
        this(f, null);
    }

    public GtfReader(String path) throws Exception {
        this(new File(path), null);
    }

    public GtfReader(String path, GtfReaderParam par) throws Exception {
        this(new File(path), par);
    }

    protected void init() throws Exception {
        String l;
        if (this.par == null) {
            this.par = new GtfReaderParam();
        }
        this.br = new BufferedReader(new FileReader(this.f));
        while ((l = this.br.readLine()) != null) {
            if (l.charAt(0) == '#') continue;
            this.buff.add(new GtfLine(l));
            break;
        }
    }

    public void start() throws Exception {
        this.ifStart = true;
        ArrayList<GtfLine> gls;
        while (!(gls = this.nextGeneChunk()).isEmpty()) {
            this.flush(this.gb, gls);
        }
        return;
    }

    public GtfReaderParam param() {
        return this.par;
    }

    public ArrayList<GtfLine> nextGeneChunk() throws Exception {
        String l;
        ArrayList<GtfLine> ret = new ArrayList<GtfLine>();
        if (!this.buff.isEmpty()) {
            ret.addAll(this.buff);
            this.buff = new ArrayList();
        }
        while ((l = this.br.readLine()) != null) {
            GtfLine gl = new GtfLine(l);
            String feat = gl.feature();
            if (feat.equals(this.par.geneDelimiterFeature)) {
                this.buff.add(gl);
                return ret;
            }
            ret.add(gl);
        }
        return ret;
    }

    private void flush(GenomicRegionsBuilder gb, ArrayList<GtfLine> buff) throws Exception {
        GtfLine gtfl = buff.get(0);
        String gid = gtfl.getField(GtfLine.FIELD_GENE_ID);
        ArrayList glss = new ArrayList();
        ArrayList<Object> trbuff = new ArrayList<Object>();
        for (int i = 1; i < buff.size(); ++i) {
            GtfLine gl = buff.get(i);
            if (gl.feature().equals(this.par.transcriptDelimiterFeature)) {
                if (!trbuff.isEmpty()) {
                    glss.add(trbuff);
                    trbuff = new ArrayList();
                }
                trbuff.add(gl);
                continue;
            }
            trbuff.add(gl);
        }
        if (!trbuff.isEmpty()) {
            glss.add(trbuff);
        }
        ArrayList<Transcript> trans = new ArrayList<Transcript>();
        for (ArrayList arrayList : glss) {
            if (arrayList.isEmpty()) continue;
            GtfLine trgl = (GtfLine)arrayList.get(0);
            ArrayList<DirectionalGenomicRegion> exs = new ArrayList<DirectionalGenomicRegion>();
            ArrayList cdss = new ArrayList();
            Region start = null;
            Region stop = null;
            for (int i = 1; i < arrayList.size(); ++i) {
                GtfLine gl = (GtfLine)arrayList.get(i);
                String chr = gl.chr();
                String feat = gl.feature();
                int low = gl.low();
                int high = gl.high();
                char std = gl.strand();
                if (feat.equals(GtfLine.FEATURE_EXON)) {
                    exs.add(new DirectionalGenomicRegion(chr, std, low, high));
                    continue;
                }
                if (feat.equals(GtfLine.FEATURE_CDS)) {
                    cdss.add(new DirectionalGenomicRegion(chr, std, low, high));
                    continue;
                }
                if (feat.equals(GtfLine.FEATURE_START_CODON)) {
                    start = new Region(gl.low(), gl.high());
                    continue;
                }
                if (!feat.equals(GtfLine.FEATURE_STOP_CODON)) continue;
                stop = new Region(gl.low(), gl.high());
            }
            Comparator<DirectionalGenomicRegion> comp = new Comparator<DirectionalGenomicRegion>(){

                @Override
                public int compare(DirectionalGenomicRegion o1, DirectionalGenomicRegion o2) {
                    return Double.compare(o1.low(), o2.low());
                }
            };
            Collections.sort(cdss, comp);
            Collections.sort(exs, comp);
            if (exs.isEmpty()) continue;
            int ll = (int)((DirectionalGenomicRegion)exs.get(0)).low();
            int hh = (int)((DirectionalGenomicRegion)exs.get(exs.size() - 1)).high();
            if (!cdss.isEmpty()) {
                ll = (int)((DirectionalGenomicRegion)cdss.get(0)).low();
                hh = (int)((DirectionalGenomicRegion)cdss.get(cdss.size() - 1)).high();
            } else if (start != null && stop != null) {
                if (trgl.strand() == '+') {
                    ll = (int)start.low();
                    hh = (int)stop.low() - 1;
                } else {
                    ll = (int)stop.high() + 1;
                    hh = (int)start.high();
                }
            }
            Transcript tr = new Transcript(gtfl.chr(), gtfl.strand(), ll, hh, exs);
            tr.setID(trgl.getField(GtfLine.FIELD_TRANSCRIPT_ID));
            tr.setAttribute(trgl);
            trans.add(tr);
        }
        Gene gene = new Gene(gtfl.chr(), gtfl.strand(), trans);
        gene.setID(gid);
        gene.setAttribute(gtfl);
        if (this.par.chrFilterIncludeMode) {
            if (this.par.chrFilter.contains(gtfl.chr())) {
                gb.add(gene);
            }
        } else if (!this.par.chrFilter.contains(gtfl.chr())) {
            gb.add(gene);
        }
    }

    public GenomicRegionsBuilder genomicRegionsBuilder() throws Exception {
        if (!this.ifStart) {
            this.start();
        }
        return this.gb;
    }

    public static void main(String[] args) throws Exception {
    }
}

