/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.gtfgff;

import fork.lib.bio.seq.parser.gtfgff.GtfLine;
import fork.lib.bio.seq.parser.gtfgff.GtfReader;
import fork.lib.bio.seq.parser.gtfgff.GtfWriterParam;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.Gene;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.Transcript;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;

public class GtfWriter {
    protected GenomicRegionsBuilder gb;
    protected GtfWriterParam par;

    public GtfWriter(GenomicRegionsBuilder gb, GtfWriterParam par) throws Exception {
        this.gb = gb;
        this.par = par;
        this.init();
    }

    public GtfWriter(GenomicRegionsBuilder gb) throws Exception {
        this(gb, null);
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = GtfWriterParam.defaultParam();
        }
    }

    public GtfWriterParam param() {
        return this.par;
    }

    public void writeToFile(String out) throws Exception {
        this.writeToFile(new File(out));
    }

    public void writeToFile(File out) throws Exception {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        for (GenomicRegion gr : this.gb) {
            ArrayList<GtfLine> lines = new ArrayList<GtfLine>();
            if (gr instanceof Gene) {
                lines.addAll(this.geneToGtf((Gene)gr));
            }
            for (GtfLine gl : lines) {
                GtfLine ngl = this.par.filter(gl);
                if (ngl == null) continue;
                bw.write(ngl.toString() + "\n");
            }
        }
        bw.close();
    }

    public ArrayList<GtfLine> transcriptToGtf(Transcript tr, String gid) throws Exception {
        ArrayList<GtfLine> ret = new ArrayList<GtfLine>();
        GtfLine trgl = (GtfLine)tr.attr();
        ret.add(trgl);
        String sour = trgl.source();
        Region cdrange = new Region(tr.lowPoint(), tr.highPoint());
        for (DirectionalGenomicRegion e : tr.children()) {
            GtfLine gl = new GtfLine(e, GtfLine.FEATURE_EXON, sour);
            gl.setField(GtfLine.FIELD_GENE_ID, gid);
            gl.setField(GtfLine.FIELD_TRANSCRIPT_ID, tr.getID());
            ret.add(gl);
            if (!e.overlapsWith(cdrange)) continue;
            GtfLine gl2 = new GtfLine(new DirectionalGenomicRegion(tr.chr(), tr.strand(), e.overlap(cdrange)), GtfLine.FEATURE_CDS, sour);
            gl2.setField(GtfLine.FIELD_GENE_ID, gid);
            gl2.setField(GtfLine.FIELD_TRANSCRIPT_ID, tr.getID());
            ret.add(gl2);
        }
        GtfLine glsta = new GtfLine(tr.startCodon(), GtfLine.FEATURE_START_CODON, sour);
        glsta.setField(GtfLine.FIELD_GENE_ID, gid);
        glsta.setField(GtfLine.FIELD_TRANSCRIPT_ID, tr.getID());
        ret.add(glsta);
        GtfLine glsto = new GtfLine(tr.stopCodon(), GtfLine.FEATURE_STOP_CODON, sour);
        glsto.setField(GtfLine.FIELD_GENE_ID, gid);
        glsto.setField(GtfLine.FIELD_TRANSCRIPT_ID, tr.getID());
        ret.add(glsto);
        return ret;
    }

    public ArrayList<GtfLine> geneToGtf(Gene gene) throws Exception {
        ArrayList<GtfLine> ret = new ArrayList<GtfLine>();
        ret.add((GtfLine)gene.attr());
        for (Transcript tr : gene.children()) {
            ret.addAll(this.transcriptToGtf(tr, gene.getID()));
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("C:\\muxingu\\genome\\human\\grch38\\ass");
        File f = new File(dir + "/Homo_sapiens.GRCh38.93_test_.gtf");
        GenomicRegionsBuilder gb = new GtfReader(f).genomicRegionsBuilder();
        GtfWriter gw = new GtfWriter(gb);
        gw.writeToFile(dir + "/test.gtf");
    }
}

