/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.gtfgff;

import fork.lib.bio.seq.parser.gtfgff.GtfLine;
import java.util.HashMap;
import java.util.HashSet;

public class GtfWriterParam {
    public static String FIELD_UNIVERSAL = "univ";
    public boolean featureIncludeMode = true;
    public boolean fieldIncludeMode = true;
    private HashSet<String> feats = new HashSet();
    private HashMap<String, HashSet<String>> fields = new HashMap();

    public GtfWriterParam() {
    }

    public GtfWriterParam(boolean includeFeatureMode, boolean IncludeFieldMode, HashSet<String> feats, HashMap<String, HashSet<String>> fields) {
        this.featureIncludeMode = includeFeatureMode;
        this.fieldIncludeMode = IncludeFieldMode;
        this.feats = feats;
        this.fields = fields;
    }

    public void setFeatureIncludeMode(boolean boo) {
        this.featureIncludeMode = boo;
    }

    public void setFieldIncludeMode(boolean boo) {
        this.fieldIncludeMode = boo;
    }

    public void addFeature(String feat) {
        this.feats.add(feat);
    }

    public void addFields(String feat, String ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            this.addField(feat, fields[i]);
        }
    }

    public void addField(String feat, String field) {
        if (!this.fields.containsKey(feat)) {
            this.fields.put(feat, new HashSet());
        }
        this.fields.get(feat).add(field);
    }

    public GtfLine filter(GtfLine gl) {
        if (gl == null) {
            return null;
        }
        if (this.featureIncludeMode ? !this.feats.contains(gl.feature()) : this.feats.contains(gl.feature())) {
            return null;
        }
        GtfLine ret = null;
        try {
            ret = gl.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ret.removeAllFields();
        HashSet<String> fset = this.fields.get(gl.feature());
        if (fset == null) {
            fset = this.fields.get(FIELD_UNIVERSAL);
        }
        for (String fk : gl.fieldKeys()) {
            if (this.fieldIncludeMode) {
                if (fset == null || !fset.contains(fk)) continue;
                ret.setField(fk, gl.getField(fk));
                continue;
            }
            if (fset != null && fset.contains(fk)) continue;
            ret.setField(fk, gl.getField(fk));
        }
        return ret;
    }

    public static GtfWriterParam defaultParam() {
        GtfWriterParam par = new GtfWriterParam();
        par.setFeatureIncludeMode(false);
        par.addFeature("CDS");
        par.addFields(FIELD_UNIVERSAL, "");
        par.addFields(GtfLine.FEATURE_GENE, "gene_id", "transcript_id", "gene_biotype", "gene_name");
        par.addFields(GtfLine.FEATURE_TRANSCRIPT, "transcript_id", "transcript_biotype");
        return par;
    }

    public static GtfWriterParam fullSimplified() {
        GtfWriterParam par = new GtfWriterParam();
        par.setFeatureIncludeMode(false);
        par.addFeature("CDS");
        par.addFields(FIELD_UNIVERSAL, "gene_id", "transcript_id");
        par.addFields(GtfLine.FEATURE_GENE, "gene_id", "transcript_id", "gene_biotype", "gene_name");
        par.addFields(GtfLine.FEATURE_TRANSCRIPT, "gene_id", "transcript_id", "transcript_biotype", "transcript_name");
        return par;
    }
}

