/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.parser.sam;

import fork.lib.bio.seq.parser.bedgraph.BedGraphExporter;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class SamReader {
    public static final int idInd = 0;
    public static final int stdInd = 1;
    public static final int chrInd = 2;
    public static final int posInd = 3;
    public static final int matchInd = 5;
    public static final int seqInd = 9;
    public static final int qualInd = 10;
    protected File f;

    public SamReader(File f) throws Exception {
        this.f = f;
        this.init();
    }

    protected void init() throws Exception {
    }

    public LandscapeBuilder getLandscapeBuilder() throws Exception {
        String l;
        LandscapeHashMap lhm = new LandscapeHashMap();
        BufferedReader br = new BufferedReader(new FileReader(this.f));
        while ((l = br.readLine()) != null) {
            String[] ss;
            String chr;
            if (l.charAt(0) == '@' || (chr = (ss = l.split("\t"))[2]).equals("*")) continue;
            double low = Double.parseDouble(ss[3]);
            double high = low + (double)ss[9].length() - 1.0;
            lhm.add(chr, (int)low, 1.0);
            lhm.add(chr, (int)high, -1.0);
        }
        br.close();
        return lhm.toLandscapeBuilder();
    }

    public static void main(String[] args) throws Exception {
        File d = new File("E:\\muxingu\\mystudy\\phd\\files\\other_datasets\\ranjan2013_swr1-chip");
        File f = new File(d + "/sort_map_GPL17387-22438_for.sam");
        SamReader sr = new SamReader(f);
        File out = new File(d + "/out.wig");
        BedGraphExporter be = new BedGraphExporter(sr.getLandscapeBuilder());
        be.writeToFile(out);
    }
}

