/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region;

import fork.lib.bio.seq.Nucleotide;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.Serializable;
import java.util.ArrayList;

public class DirectionalGenomicRegion<P extends GenomicRegion, C extends GenomicRegion>
extends GenomicRegion<P, C>
implements Serializable {
    protected char strand = (char)46;

    public DirectionalGenomicRegion(String chr, char strand, int low, int high) throws Exception {
        super(chr, low, high);
        this.strand = strand;
        this.init();
    }

    public DirectionalGenomicRegion(String chr, char strand, double low, double high) throws Exception {
        this(chr, strand, (int)low, (int)high);
    }

    public DirectionalGenomicRegion(String chr, int low, int high) throws Exception {
        super(chr, low, high);
        this.init();
    }

    public DirectionalGenomicRegion(String chr, char strand, Region reg) throws Exception {
        this(chr, strand, (int)reg.low(), (int)reg.high());
        this.attr = reg.attr();
    }

    public DirectionalGenomicRegion(char strand, GenomicRegion gr) throws Exception {
        this(gr.chr, strand, (int)gr.low(), (int)gr.high());
        this.attr = gr.attr();
    }

    public DirectionalGenomicRegion(String chr, Region r) throws Exception {
        this(chr, (int)r.low(), (int)r.high());
        this.attr = r.attr();
    }

    public DirectionalGenomicRegion() {
    }

    private void init() throws Exception {
        if (this.strand != '+' && this.strand != '-' && this.strand != '.') {
            throw new Exception("Illegal strand:" + this.strand);
        }
    }

    public char strand() {
        return this.strand;
    }

    public void setStrand(char std) {
        this.strand = std == '+' || std == '-' ? std : (char)46;
    }

    public int fivePrimeEnd() {
        if (this.isOnForwardStrand()) {
            return (int)this.low;
        }
        return (int)this.high;
    }

    public DirectionalGenomicRegion promoter(int side) {
        int fp = this.fivePrimeEnd();
        try {
            return new DirectionalGenomicRegion<P, C>(this.chr, this.strand, fp - side, fp + side);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int threePrimeEnd() {
        if (this.isOnReverseStrand()) {
            return (int)this.low;
        }
        return (int)this.high;
    }

    @Override
    public DirectionalGenomicRegion clone() {
        return (DirectionalGenomicRegion)super.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DirectionalGenomicRegion reg = (DirectionalGenomicRegion)obj;
        return reg.chr.equals(this.chr) && reg.strand == this.strand && reg.low == this.low && reg.high == this.high;
    }

    @Override
    public int hashCode() {
        int hash = this.strand * 19 + super.hashCode();
        return hash;
    }

    public boolean isOnForwardStrand() {
        return this.strand == '+';
    }

    public boolean isOnReverseStrand() {
        return this.strand == '-';
    }

    public boolean isOnUnkownStrand() {
        return this.strand == '.';
    }

    public DirectionalGenomicRegion getFivePrimeEnd(int ups, int downs) throws Exception {
        int m = this.strand == '+' ? (int)this.low : (int)this.high;
        int l = this.strand == '+' ? m - ups : m - (downs - 1);
        int r = this.strand == '+' ? m + (downs - 1) : m + ups;
        DirectionalGenomicRegion<P, C> ret = null;
        try {
            ret = new DirectionalGenomicRegion<P, C>(this.chr, this.strand, l, r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public DirectionalGenomicRegion getThreePrimeEnd(int ups, int downs) throws Exception {
        int m = this.strand == '+' ? (int)this.high : (int)this.low;
        int l = this.strand == '+' ? m - ups : m - (downs - 1);
        int r = this.strand == '+' ? m + (downs - 1) : m + ups;
        DirectionalGenomicRegion<P, C> ret = null;
        try {
            ret = new DirectionalGenomicRegion<P, C>(this.chr, this.strand, l, r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Region getGenicRegion(int fpu, int tpd) throws Exception {
        int l = this.strand == '+' ? (int)this.low + fpu : (int)this.low + tpd;
        int r = this.strand == '+' ? (int)this.high - tpd : (int)this.high - fpu;
        return new DirectionalGenomicRegion<P, C>(this.chr, this.strand, l, r);
    }

    @Override
    public DirectionalGenomicRegion getExtendedRegion(int up, int down) throws Exception {
        int l = this.isOnForwardStrand() ? (int)this.low - up : (int)this.low - down;
        int h = this.isOnForwardStrand() ? (int)this.high + down : (int)this.high + up;
        DirectionalGenomicRegion ret = this.clone();
        ret.setLowHigh(l, h);
        return ret;
    }

    @Override
    public String sequence(String cs) {
        if (this.isOnForwardStrand() || this.isOnUnkownStrand()) {
            return super.sequence(cs);
        }
        return Nucleotide.reverseComplement(super.sequence(cs));
    }

    @Override
    public void print() {
        System.out.println(this.toUCSCFormat());
    }

    @Override
    public void printInt() {
        System.out.println(this.toString());
    }

    @Override
    public String toString() {
        return this.toUCSCFormatStrand();
    }

    public String toUCSCFormatStrand() {
        return super.toUCSCFormat() + "_" + this.strand;
    }

    public static DirectionalGenomicRegion parseDirectionalGenomicUCSC(String s) throws Exception {
        String[] ss = s.split("_");
        String[] ss2 = ss[0].split("-|:");
        return new DirectionalGenomicRegion(ss2[0], ss[1].charAt(0), Integer.parseInt(ss2[1]), Integer.parseInt(ss2[2]));
    }

    public static String seq(String cs, ArrayList regs, boolean isfor) {
        StringBuilder sb = new StringBuilder();
        if (isfor) {
            for (Object o : regs) {
                sb.append(((DirectionalGenomicRegion)o).sequence(cs));
            }
        } else {
            for (int i = regs.size() - 1; i >= 0; --i) {
                sb.append(((DirectionalGenomicRegion)regs.get(i)).sequence(cs));
            }
        }
        return sb.toString();
    }
}

