/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region;

import fork.lib.bio.seq.parser.gtfgff.GtfLine;
import fork.lib.bio.seq.region.Chromosome;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.Transcript;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.builder.GenomicRegionsMerger;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.algebra.elementary.set.continuous.RegionsOp;
import java.io.Serializable;
import java.util.ArrayList;

public class Gene
extends DirectionalGenomicRegion<Chromosome, Transcript>
implements Serializable {
    public Gene(String chr, char strand, ArrayList<Transcript> trans) throws Exception {
        super(chr, strand, RegionsOp.range(trans));
        this.addChildren(RegionsOp.sortByLow(trans));
        this.init();
    }

    public Gene() {
    }

    protected void init() throws Exception {
    }

    public GenomicRegionsBuilder getAllExons() throws Exception {
        return Gene.exonsForTranscripts(this.children(), this.getID(), this.isOnForwardStrand());
    }

    public static GenomicRegionsBuilder exonsForTranscripts(ArrayList<Transcript> trs, String id, boolean isfor) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (Transcript t : trs) {
            for (DirectionalGenomicRegion e : t.children()) {
                ret.add(e);
            }
        }
        ret.sortAll();
        ret = GenomicRegionsMerger.merge(ret);
        ret.sortAll();
        if (isfor) {
            int ind = 1;
            for (GenomicRegion gr : ret) {
                gr.setID(id + "_E" + ind);
                ++ind;
            }
        } else {
            int ind = ret.size();
            for (GenomicRegion gr : ret) {
                gr.setID(id + "_E" + ind);
                --ind;
            }
        }
        return ret;
    }

    public GenomicRegionsBuilder getAllIntrons() throws Exception {
        GenomicRegionsBuilder exs = new GenomicRegionsBuilder();
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (Transcript t : this.children) {
            for (DirectionalGenomicRegion e : t.children()) {
                exs.add(e);
            }
        }
        exs.sortAll();
        exs = GenomicRegionsMerger.merge(exs);
        exs.sortAll();
        ArrayList<Region> regs = exs.getRegionsForChromosome(this.chr);
        if (this.isOnForwardStrand()) {
            int ind = 1;
            for (int i = 0; i < regs.size() - 1; ++i) {
                double ll = regs.get(i).high() + 1.0;
                double hh = regs.get(i + 1).low() - 1.0;
                if (!(hh - ll > 100.0)) continue;
                DirectionalGenomicRegion dr = new DirectionalGenomicRegion(this.chr, this.strand, ll, hh);
                dr.setID(this.id + "_I" + ind);
                ++ind;
                ret.add(dr);
            }
        } else if (this.isOnReverseStrand()) {
            int ind = 1;
            for (int i = regs.size() - 1; i > 0; --i) {
                double ll = regs.get(i - 1).high() + 1.0;
                double hh = regs.get(i).low() - 1.0;
                if (!(hh - ll > 100.0)) continue;
                DirectionalGenomicRegion dr = new DirectionalGenomicRegion(this.chr, this.strand, ll, hh);
                dr.setID(this.id + "_I" + ind);
                ++ind;
                ret.add(dr);
            }
        }
        ret.sortAll();
        return ret;
    }

    public int exonLength() throws Exception {
        GenomicRegionsBuilder ex = this.getAllExons();
        int len = 0;
        for (GenomicRegion gr : ex) {
            len = (int)((double)len + gr.getRange());
        }
        return len;
    }

    @Override
    public String sequence(String cs) {
        return Transcript.seq(cs, this.children, this.isOnForwardStrand());
    }

    @Override
    public void print() {
        super.print();
        for (Transcript tr : this.children()) {
            System.out.print("    ");
            tr.print();
            for (DirectionalGenomicRegion ex : tr.children()) {
                System.out.print("        ");
                ex.print();
            }
        }
    }

    public boolean exonContains(GenomicRegion gr) {
        for (Transcript tr : this.children()) {
            for (DirectionalGenomicRegion dr : tr.children()) {
                if (!dr.overlapsWith(gr)) continue;
                return true;
            }
        }
        return false;
    }

    public String name() {
        try {
            return ((GtfLine)this.attr).getField(GtfLine.FIELD_GENE_NAME);
        }
        catch (Exception e) {
            return this.getID();
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

