/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class GenomicRegion<P extends GenomicRegion, C extends GenomicRegion>
extends Region
implements Serializable {
    protected String chr = null;
    protected String id = "";
    protected double val = 0.0;
    protected P parent = null;
    protected ArrayList<C> children = new ArrayList();

    public GenomicRegion(String chr, int low, int high) throws Exception {
        super(low, high);
        this.chr = chr;
    }

    public GenomicRegion(String chr, double low, double high) throws Exception {
        this(chr, (int)low, (int)high);
    }

    public GenomicRegion(String chr, Region reg) throws Exception {
        this(chr, (int)reg.low(), (int)reg.high());
        this.attr = reg.attr();
    }

    public GenomicRegion(int low, int high) throws Exception {
        super(low, high);
    }

    public GenomicRegion(Region reg) throws Exception {
        this((int)reg.low(), (int)reg.high());
        this.attr = reg.attr();
    }

    public GenomicRegion() {
    }

    @Override
    public GenomicRegion clone() {
        return (GenomicRegion)super.clone();
    }

    public String chr() {
        if (this.chr == null) {
            return ((GenomicRegion)this.parent).chr();
        }
        return this.chr;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public void addChild(C c) {
        this.children.add(c);
        ((GenomicRegion)c).setParent((GenomicRegion)this);
        if (this.chr == null && ((GenomicRegion)c).chr() != null) {
            this.chr = ((GenomicRegion)c).chr();
            ((GenomicRegion)c).setChr(null);
        }
    }

    public void addChildren(ArrayList cs) {
        for (int i = 0; i < cs.size(); ++i) {
            this.addChild((GenomicRegion)cs.get(i));
        }
    }

    public ArrayList<C> children() {
        return this.children;
    }

    public void setParent(P par) {
        this.parent = par;
    }

    public GenomicRegion getParent() {
        return this.parent;
    }

    @Override
    public double getRange() {
        return super.getRange() + 1.0;
    }

    public String toBedFormat() {
        return GenomicRegion.toBedFormat(this);
    }

    public static String toBedFormat(GenomicRegion r) {
        return r.chr + "\t" + (int)r.low + "\t" + ((int)r.high + 1);
    }

    public String toUCSCFormat() {
        return GenomicRegion.toUCSCFormat(this);
    }

    public static String toUCSCFormat(GenomicRegion r) {
        return r.chr + ":" + (int)r.low + "-" + (int)r.high;
    }

    @Override
    public double distanceFrom(Number n) {
        double v = n.doubleValue();
        if (v > this.high) {
            return v - this.high - 1.0;
        }
        if (this.low > v) {
            return this.low - v - 1.0;
        }
        return 0.0;
    }

    public String sequence(String cs) {
        return cs.substring((int)this.low - 1, (int)this.high);
    }

    public static GenomicRegion parseGenomicRegoinUCSC(String s) throws Exception {
        String[] ss = s.split("-|:");
        return new GenomicRegion(ss[0], Integer.parseInt(ss[1]), Integer.parseInt(ss[2]));
    }

    public GenomicRegion getExtendedRegion(int left, int right) throws Exception {
        GenomicRegion ret = this.clone();
        ret.setLowHigh((int)this.low - left, (int)this.high + right);
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GenomicRegion reg = (GenomicRegion)obj;
        return reg.chr.equals(this.chr) && reg.low == this.low && reg.high == this.high;
    }

    @Override
    public int hashCode() {
        int hash = this.chr.hashCode() * 13 + super.hashCode();
        return hash;
    }

    @Override
    public void print() {
        System.out.println(this.chr + "  " + this.low + "  " + this.high);
    }

    @Override
    public void printInt() {
        System.out.println(this.toString());
    }

    @Override
    public String toString() {
        return this.toUCSCFormat();
    }

    public String getID() {
        return this.id.equals("") ? this.toUCSCFormat() : this.id;
    }

    public double getValue() {
        return this.val;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setValue(double v) {
        this.val = v;
    }

    public void copyAttributes(GenomicRegion gr) {
        this.setAttribute(gr.attr());
        this.setID(gr.getID());
        this.setValue(gr.getValue());
    }

    public static void main(String[] args) throws Exception {
        GenomicRegion ga = new GenomicRegion("chr1", 100, 200);
        ga.attr = "aa";
        GenomicRegion gb = new GenomicRegion("chr1", 100, 200);
        System.out.println(ga.equals(gb));
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("test.o"));
        out.writeObject(ga);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("test.o"));
        GenomicRegion xx = (GenomicRegion)in.readObject();
        in.close();
        System.out.println(xx);
    }
}

