/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region;

import fork.lib.bio.seq.parser.gtfgff.GtfReader;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.Gene;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.algebra.elementary.set.continuous.RegionsOp;
import java.io.Serializable;
import java.util.ArrayList;

public class Transcript
extends DirectionalGenomicRegion<Gene, DirectionalGenomicRegion>
implements Serializable {
    public static String START_CODON = "start-codon";
    public static String STOP_CODON = "stop-codon";
    public static String CDS = "cds";
    public static String EXON = "exon";
    public static String INTRON = "intron";
    protected int lowPoint;
    protected int highPoint;

    public Transcript(String chr, char strand, int lowpoint, int highpoint, ArrayList<DirectionalGenomicRegion> exons) throws Exception {
        super(chr, strand, RegionsOp.range(exons));
        this.lowPoint = lowpoint;
        this.highPoint = highpoint;
        this.addChildren(RegionsOp.sortByLow(exons));
        this.init();
    }

    public Transcript(String chr, char strand, ArrayList<DirectionalGenomicRegion> exons) throws Exception {
        this(chr, strand, (int)exons.get(0).low(), (int)exons.get(exons.size() - 1).high(), exons);
    }

    public Transcript() {
    }

    protected void init() throws Exception {
        if (this.highPoint < this.lowPoint) {
            throw new Exception();
        }
    }

    public int lowPoint() {
        return this.lowPoint;
    }

    public int highPoint() {
        return this.highPoint;
    }

    public DirectionalGenomicRegion startCodon() throws Exception {
        if (this.isOnForwardStrand()) {
            DirectionalGenomicRegion ret = new DirectionalGenomicRegion(this.chr, this.strand, this.lowPoint, this.lowPoint + 2);
            ret.setID(this.id + "_" + START_CODON);
            return ret;
        }
        if (this.isOnReverseStrand()) {
            DirectionalGenomicRegion ret = new DirectionalGenomicRegion(this.chr, this.strand, this.highPoint - 2, this.highPoint);
            ret.setID(this.id + "_" + STOP_CODON);
            return ret;
        }
        throw new Exception("Unknown strand: " + this.strand);
    }

    public DirectionalGenomicRegion stopCodon() throws Exception {
        if (this.isOnForwardStrand()) {
            DirectionalGenomicRegion ret = new DirectionalGenomicRegion(this.chr, this.strand, this.highPoint + 1, this.highPoint + 3);
            ret.setID(this.id + "_" + STOP_CODON);
            return ret;
        }
        if (this.isOnReverseStrand()) {
            DirectionalGenomicRegion ret = new DirectionalGenomicRegion(this.chr, this.strand, this.lowPoint - 3, this.lowPoint - 1);
            ret.setID(this.id + "_" + START_CODON);
            return ret;
        }
        throw new Exception("Unknown strand: " + this.strand);
    }

    public ArrayList<DirectionalGenomicRegion> fivePrimeUTR() {
        ArrayList<DirectionalGenomicRegion> ret = new ArrayList();
        if (this.isOnForwardStrand()) {
            ret = this.utrLow();
        } else if (this.isOnReverseStrand()) {
            ret = this.utrHigh();
        }
        return ret;
    }

    public ArrayList<DirectionalGenomicRegion> threePrimeUTR() {
        ArrayList<DirectionalGenomicRegion> ret = new ArrayList();
        if (this.isOnForwardStrand()) {
            ret = this.utrHigh();
        } else if (this.isOnReverseStrand()) {
            ret = this.utrLow();
        }
        return ret;
    }

    private ArrayList<DirectionalGenomicRegion> utrLow() {
        ArrayList<DirectionalGenomicRegion> ret = new ArrayList<DirectionalGenomicRegion>();
        for (DirectionalGenomicRegion ex : this.children) {
            if (ex.high() <= (double)this.lowPoint) {
                ret.add(ex);
                continue;
            }
            if (!(ex.low() < (double)this.lowPoint)) continue;
            try {
                ret.add(new DirectionalGenomicRegion(this.chr, this.strand, ex.low(), (double)this.lowPoint));
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    private ArrayList<DirectionalGenomicRegion> utrHigh() {
        ArrayList<DirectionalGenomicRegion> ret = new ArrayList<DirectionalGenomicRegion>();
        for (DirectionalGenomicRegion ex : this.children) {
            if (ex.low() >= (double)this.lowPoint) {
                ret.add(ex);
                continue;
            }
            if (!(ex.high() > (double)this.highPoint)) continue;
            try {
                ret.add(new DirectionalGenomicRegion(this.chr, this.strand, (double)this.highPoint, ex.high()));
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public ArrayList<DirectionalGenomicRegion> CDS() {
        ArrayList<DirectionalGenomicRegion> ret;
        block8: {
            block7: {
                Region cdrange = null;
                try {
                    cdrange = new Region(this.lowPoint, this.highPoint);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                ret = new ArrayList<DirectionalGenomicRegion>();
                for (DirectionalGenomicRegion e : this.children) {
                    if (!e.overlapsWith(cdrange)) continue;
                    Region o = null;
                    try {
                        o = e.overlap(cdrange);
                        ret.add(new DirectionalGenomicRegion(this.chr, this.strand, o));
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (!this.isOnForwardStrand()) break block7;
                for (int i = 0; i < ret.size(); ++i) {
                    ret.get(i).setID(this.getID() + "_" + CDS + "-" + (i + 1));
                }
                break block8;
            }
            if (!this.isOnReverseStrand()) break block8;
            for (int i = 0; i < ret.size(); ++i) {
                ret.get(i).setID(this.getID() + "_" + CDS + "-" + (ret.size() - i));
            }
        }
        return ret;
    }

    public int cdsLength() {
        int ret = 0;
        for (DirectionalGenomicRegion cd : this.CDS()) {
            ret = (int)((double)ret + cd.getRange());
        }
        return ret;
    }

    @Override
    public String sequence(String cs) {
        return Transcript.seq(cs, this.children(), this.isOnForwardStrand());
    }

    public String sequenceCDS(String cs) {
        return Transcript.seq(cs, this.CDS(), this.isOnForwardStrand());
    }

    public static void main(String[] args) throws Exception {
        GenomicRegionsBuilder gb = new GtfReader("C:\\muxingu\\genome\\human\\grch38\\ass/Homo_sapiens.GRCh38.93_pc.gtfmin").genomicRegionsBuilder();
        for (GenomicRegion gr : gb) {
            Gene g = (Gene)gr;
            for (Transcript tr : g.children()) {
                System.out.println(tr.children);
                System.out.println(tr.lowPoint + " " + tr.highPoint);
                System.out.println(tr.fivePrimeUTR());
                System.out.println(tr.threePrimeUTR());
                System.out.println();
            }
            System.exit(1);
        }
    }
}

