/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.builder;

import fork.lib.base.format.collection.FormatOp1D;
import fork.lib.bio.seq.parser.bed.BedWriter;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeHashMap;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.algebra.elementary.set.continuous.RegionsOp;
import fork.lib.math.applied.stat.FrequencyCount;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class GenomicRegionsBuilder
extends GenomicRegionsBuffer
implements Iterable<GenomicRegion>,
Cloneable {
    public static String UCSC = "ucsc";
    public static String BED = "bed";
    public static String CHR = "chr";
    protected HashMap<String, ArrayList<Region>> map;
    protected HashSet<String> ids = new HashSet();

    public GenomicRegionsBuilder() {
        this.init();
    }

    private void init() {
        this.map = new HashMap();
    }

    public void add(GenomicRegion r) {
        if (r == null) {
            return;
        }
        String chr = r.chr();
        if (!this.map.containsKey(chr)) {
            this.map.put(chr, new ArrayList());
        }
        this.map.get(chr).add(r);
    }

    public boolean remove(GenomicRegion r) {
        String chr = r.chr();
        if (!this.map.containsKey(chr)) {
            return false;
        }
        this.ids.remove(r.getID());
        return this.map.get(chr).remove(r);
    }

    public void addAll(String chr, ArrayList<Region> regs) {
        if (!this.map.containsKey(chr)) {
            this.map.put(chr, new ArrayList());
        }
        if (regs == null || regs.isEmpty()) {
            return;
        }
        for (int i = 0; i < regs.size(); ++i) {
            Region o = regs.get(i);
            this.map.get(chr).add(o);
        }
    }

    public void addAll(GenomicRegionsBuilder b) {
        for (GenomicRegion gr : b) {
            this.add(gr);
        }
    }

    public void sortAll() {
        for (String chr : this.map.keySet()) {
            this.map.put(chr, RegionsOp.sortByLow(this.map.get(chr)));
        }
    }

    public void sortAllByHigh() {
        for (String chr : this.map.keySet()) {
            this.map.put(chr, RegionsOp.sortByHigh(this.map.get(chr)));
        }
    }

    public void removeRedundant() {
        String[] chrs = this.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            ArrayList<Region> rs = this.map.get(chr);
            ArrayList<Region> nrs = new ArrayList<Region>();
            HashSet<Region> set = new HashSet<Region>();
            for (int j = 0; j < rs.size(); ++j) {
                Region r = rs.get(j);
                if (set.contains(r)) continue;
                set.add(r);
                nrs.add(r);
            }
            this.map.put(chr, nrs);
        }
    }

    @Override
    public String[] getChromosomeList() {
        Object[] ret = new String[this.map.keySet().size()];
        this.map.keySet().toArray(ret);
        Arrays.sort(ret);
        return ret;
    }

    public ArrayList<String> chromosomeList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.map.keySet());
        Collections.sort(ret);
        return ret;
    }

    @Override
    public String[] getUnsortedChromosomeList() {
        String[] ret = new String[this.map.keySet().size()];
        this.map.keySet().toArray(ret);
        return ret;
    }

    @Override
    public boolean containsChromosome(String chr) {
        return this.map.containsKey(chr);
    }

    public ArrayList<Region> getRegionsForChromosome(String chr) {
        return this.map.containsKey(chr) ? this.map.get(chr) : new ArrayList<Region>();
    }

    public ArrayList<GenomicRegion> getAllGenomicRegions() {
        ArrayList<GenomicRegion> ret = new ArrayList<GenomicRegion>();
        Iterator<GenomicRegion> it = this.iterator();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public GenomicRegionsBuilder getGenomicRegionsBuilderForChromosome(String chr) {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        if (!this.map.containsKey(chr)) {
            return ret;
        }
        ret.addAll(chr, this.map.get(chr));
        return ret;
    }

    @Override
    public Iterator<GenomicRegion> iterator() {
        return new Iterator<GenomicRegion>(){
            String[] chrs = this.chrs();
            int chrInd = 0;
            int arrInd = 0;

            protected String[] chrs() {
                Object[] ret = FormatOp1D.objToString(GenomicRegionsBuilder.this.map.keySet().toArray());
                Arrays.sort(ret);
                return ret;
            }

            @Override
            public boolean hasNext() {
                if (this.chrInd <= this.chrs.length - 1) {
                    ArrayList<Region> al = GenomicRegionsBuilder.this.map.get(this.chrs[this.chrInd]);
                    if (al.isEmpty()) {
                        ++this.chrInd;
                        this.arrInd = 0;
                        return this.hasNext();
                    }
                    return this.arrInd <= al.size() - 1;
                }
                return false;
            }

            @Override
            public GenomicRegion next() {
                String chr = this.chrs[this.chrInd];
                Region r = GenomicRegionsBuilder.this.map.get(chr).get(this.arrInd);
                GenomicRegion ret = null;
                try {
                    ret = r instanceof GenomicRegion ? (GenomicRegion)r : new GenomicRegion(chr, r);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.arrInd >= GenomicRegionsBuilder.this.map.get(this.chrs[this.chrInd]).size() - 1) {
                    this.arrInd = 0;
                    ++this.chrInd;
                } else {
                    ++this.arrInd;
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public LandscapeBuilder toLandscape() throws Exception {
        LandscapeBuilder lb = new LandscapeBuilder();
        for (GenomicRegion r : this) {
            lb.add(r.chr(), new Region(r.low(), Double.parseDouble(r.attr().toString())));
        }
        return lb;
    }

    public double totalLength(double incr) {
        double ret = 0.0;
        for (GenomicRegion r : this) {
            ret += r.getRange() + 1.0 + incr;
        }
        return ret;
    }

    public void switchChromosomeAddChr() {
        HashMap<String, ArrayList<Region>> map_ = new HashMap<String, ArrayList<Region>>();
        for (String c : this.map.keySet()) {
            ArrayList<Region> rs = this.map.get(c);
            for (Region r : rs) {
                GenomicRegion gr = (GenomicRegion)r;
                if (gr.chr().contains("chr")) continue;
                gr.setChr("chr" + gr.chr());
            }
            if (c.contains(CHR)) continue;
            map_.put(CHR + c, rs);
        }
        this.map = map_;
    }

    public void switchChromosomeRemoveChr() {
        HashMap<String, ArrayList<Region>> map_ = new HashMap<String, ArrayList<Region>>();
        for (String c : this.map.keySet()) {
            ArrayList<Region> rs = this.map.get(c);
            for (Region r : rs) {
                GenomicRegion gr = (GenomicRegion)r;
                if (gr.chr().indexOf(CHR) != 0) continue;
                gr.setChr(gr.chr().substring(CHR.length()));
            }
            if (c.indexOf(CHR) != 0) continue;
            map_.put(c.substring(CHR.length()), rs);
        }
        this.map = map_;
    }

    public double totalLength() {
        return this.totalLength(0.0);
    }

    public int size() {
        int ret = 0;
        String[] chrs = this.getChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            ret += this.map.get(chr).size();
        }
        return ret;
    }

    public void put(String chr, ArrayList<Region> rs) {
        this.map.put(chr, rs);
    }

    public void writeToFile(File out, String format) throws Exception {
        if (format.equals(UCSC)) {
            this.writeToFileUCSC(out);
        } else if (format.equals(BED)) {
            this.writeToFileBed(out);
        }
    }

    public void writeToFileUCSC(File out) throws Exception {
        out.getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        for (String chr : this.map.keySet()) {
            ArrayList<Region> rs = this.map.get(chr);
            for (int i = 0; i < rs.size(); ++i) {
                try {
                    GenomicRegion gr = new GenomicRegion(chr, rs.get(i));
                    bw.write(gr.toUCSCFormat() + "\n");
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        bw.close();
    }

    public void writeToFileBed(File out) throws Exception {
        BedWriter be = new BedWriter(this, null);
        be.writeToFile(out);
    }

    public GenomicRegionsBuilder clone() {
        try {
            return (GenomicRegionsBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public HashMap<String, GenomicRegion> idToGenomicRegionMap() {
        HashMap<String, GenomicRegion> ret = new HashMap<String, GenomicRegion>();
        for (GenomicRegion gr : this) {
            String id = gr.getID();
            ret.put(id, gr);
        }
        return ret;
    }

    public LandscapeBuilder toLandscapeBuilder() throws Exception {
        LandscapeBuilder ret = new LandscapeBuilder();
        String[] chrs = this.getUnsortedChromosomeList();
        block0: for (int i = 0; i < chrs.length; ++i) {
            int j;
            String chr = chrs[i];
            ArrayList<Region> regs = this.getRegionsForChromosome(chr);
            int low = (int)regs.get(0).low();
            int high = (int)regs.get(regs.size() - 1).high();
            double[] vs = new double[high - low + 1];
            for (j = 0; j < regs.size(); ++j) {
                Region r = regs.get(j);
                int k = (int)r.low();
                while ((double)k <= r.high()) {
                    int n = k - low;
                    vs[n] = vs[n] + 1.0;
                    ++k;
                }
            }
            j = 0;
            while (j < vs.length) {
                double v = vs[j];
                if (j == vs.length - 1) {
                    Region r = new Region(low + j, low + j);
                    r.setAttribute(v);
                    ret.add(chr, r);
                    continue block0;
                }
                double nv = vs[j + 1];
                int l = j;
                while (nv == v && ++j < vs.length - 1) {
                    nv = vs[j + 1];
                }
                int h = j++;
                Region r = new Region(l + low, h + low);
                r.setAttribute(v);
                ret.add(chr, r);
            }
        }
        return ret;
    }

    public LandscapeBuilder toCoverage() throws Exception {
        LandscapeHashMap lhm = new LandscapeHashMap();
        for (GenomicRegion gr : this) {
            double low = gr.low();
            double high = gr.high();
            String chr = gr.chr();
            lhm.add(chr, (int)low, 1.0);
            lhm.add(chr, (int)high, -1.0);
        }
        return lhm.toLandscapeBuilder();
    }

    public FrequencyCount<Integer> lengthDistribution() throws Exception {
        FrequencyCount<Integer> fc = new FrequencyCount<Integer>();
        for (GenomicRegion gr : this) {
            fc.add((int)(gr.getRange() + 1.0));
        }
        return fc;
    }

    public void print() {
        Iterator<GenomicRegion> it = this.iterator();
        while (it.hasNext()) {
            it.next().printInt();
        }
    }

    public static ArrayList<GenomicRegion> sortGenomicRegionsByLow(Collection<GenomicRegion> rs) {
        GenomicRegionsBuilder gb = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = rs.iterator();
        while (it.hasNext()) {
            gb.add(it.next());
        }
        gb.sortAll();
        ArrayList<GenomicRegion> ret = new ArrayList<GenomicRegion>();
        it = gb.iterator();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public void removeAttributes() throws Exception {
        for (GenomicRegion gr : this) {
            gr.setAttribute(null);
        }
    }

    public GenomicRegionsBuilder getRegionsWithValue(double val) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (GenomicRegion gr : this) {
            if (gr.getValue() != val) continue;
            ret.add(gr);
        }
        return ret;
    }

    public void removeChromosome(String chr) throws Exception {
        if (this.map.containsKey(chr)) {
            this.map.remove(chr);
        }
    }

    public static void main(String[] args) throws Exception {
        GenomicRegionsBuilder gb = new GenomicRegionsBuilder();
        gb.add(new GenomicRegion("chr1", 100, 200));
        gb.add(new GenomicRegion("chr1", 100, 200));
        gb.add(new GenomicRegion("chr1", 50, 300));
        gb.add(new GenomicRegion("chr1", 10, 20));
        gb.add(new GenomicRegion("chr2", 300, 400));
        gb.add(new GenomicRegion("chr2", 30, 450));
        gb.add(new GenomicRegion("chr2", 50, 400));
        GenomicRegionsBuilder gb2 = gb.clone();
        for (GenomicRegion r : gb2) {
            r.printIntAfter(r.chr() + "  ");
        }
    }
}

