/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.builder;

import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.builder.GenomicRegionsModifier;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.applied.buffer.RegionBuffer;
import java.util.ArrayList;

public class GenomicRegionsComparator {
    protected GenomicRegionsBuilder gb;
    protected GenomicRegionsBuilder gbref;
    protected GenomicRegionsBuilder gbin = new GenomicRegionsBuilder();
    protected GenomicRegionsBuilder gbout = new GenomicRegionsBuilder();
    protected boolean ifstart = false;
    public boolean strandedMode = true;

    public GenomicRegionsComparator(GenomicRegionsBuilder gb, GenomicRegionsBuilder gbref, boolean strandmode) {
        this.gb = gb;
        this.gbref = gbref;
        this.strandedMode = strandmode;
    }

    public GenomicRegionsComparator(GenomicRegionsBuilder gb, GenomicRegionsBuilder gbref) {
        this(gb, gbref, true);
    }

    protected ArrayList<GenomicRegionsBuilder> startStrand(GenomicRegionsBuilder gb, GenomicRegionsBuilder gbex) throws Exception {
        ArrayList<GenomicRegionsBuilder> ret = new ArrayList<GenomicRegionsBuilder>();
        GenomicRegionsBuilder gbin = new GenomicRegionsBuilder();
        GenomicRegionsBuilder gbout = new GenomicRegionsBuilder();
        for (String chr : gb.chromosomeList()) {
            if (gbex.containsChromosome(chr)) {
                ArrayList<Region> rs = gb.getRegionsForChromosome(chr);
                ArrayList<Region> refrs = gbex.getRegionsForChromosome(chr);
                RegionBuffer rb = new RegionBuffer(refrs);
                for (Region r : rs) {
                    GenomicRegion gr = (GenomicRegion)r.clone();
                    ArrayList<Region> bufrs = rb.reloadAndGetList(r);
                    if (bufrs.isEmpty()) {
                        gbout.add(gr);
                        continue;
                    }
                    gr.setAttribute(bufrs.clone());
                    gbin.add(gr);
                }
                continue;
            }
            gbout.addAll(gb.getGenomicRegionsBuilderForChromosome(chr));
        }
        gbin.sortAll();
        gbout.sortAll();
        ret.add(gbin);
        ret.add(gbout);
        return ret;
    }

    public void start() throws Exception {
        if (this.strandedMode) {
            ArrayList<GenomicRegionsBuilder> gsfor = this.startStrand(GenomicRegionsModifier.getForwardStrand(this.gb), GenomicRegionsModifier.getForwardStrand(this.gbref));
            ArrayList<GenomicRegionsBuilder> gsrev = this.startStrand(GenomicRegionsModifier.getReverseStrand(this.gb), GenomicRegionsModifier.getReverseStrand(this.gbref));
            this.gbin.addAll(gsfor.get(0));
            this.gbin.addAll(gsrev.get(0));
            this.gbout.addAll(gsfor.get(1));
            this.gbout.addAll(gsrev.get(1));
            this.gbin.sortAll();
            this.gbout.sortAll();
            this.ifstart = true;
        } else {
            ArrayList<GenomicRegionsBuilder> gs = this.startStrand(this.gb, this.gbref);
            this.gbin = gs.get(0);
            this.gbout = gs.get(1);
            this.ifstart = true;
        }
    }

    public GenomicRegionsBuilder intersection() throws Exception {
        if (!this.ifstart) {
            this.start();
        }
        return this.gbin;
    }

    public GenomicRegionsBuilder outside() throws Exception {
        if (!this.ifstart) {
            this.start();
        }
        return this.gbout;
    }
}

