/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.builder;

import fork.lib.base.collection.NamedTable;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.applied.buffer.RegionBuffer;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenomicRegionsMerger {
    protected DecimalFormat df = new DecimalFormat("#.####");
    protected ArrayList<GenomicRegionsBuilder> gbs = new ArrayList();
    protected ArrayList<String> tags = new ArrayList();
    protected ArrayList<Integer> nonzeros = new ArrayList();
    protected GenomicRegionsBuilder gbmer;
    protected NamedTable<String, String, String> otab = new NamedTable();
    private String defaultValue = "0";

    public GenomicRegionsMerger(GenomicRegionsBuilder[] gbs, String[] tags) {
        this(Arrays.asList(gbs), Arrays.asList(tags));
    }

    public GenomicRegionsMerger(List<GenomicRegionsBuilder> gbs, List<String> tags) {
        this.gbs.addAll(gbs);
        this.tags.addAll(tags);
    }

    public void start() throws Exception {
        this.gbmer = this.gbs.get(0);
        for (int i = 1; i < this.gbs.size(); ++i) {
            this.gbmer = this.merge(this.gbmer, this.gbs.get(i));
        }
        for (GenomicRegion gr : this.gbmer) {
            this.otab.appendEmptyRow(gr.toUCSCFormat());
        }
        for (int i = 0; i < this.gbs.size(); ++i) {
            GenomicRegionsBuilder gb = this.gbs.get(i);
            String coln = this.tags.get(i);
            this.otab.appendEmptyColumn(coln);
            int nzs = 0;
            for (String chr : this.gbmer.getChromosomeList()) {
                RegionBuffer rb = new RegionBuffer(gb.getRegionsForChromosome(chr));
                for (Region r : this.gbmer.getRegionsForChromosome(chr)) {
                    String rown = ((GenomicRegion)r).toUCSCFormat();
                    ArrayList<Region> bufrs = rb.reloadAndGetList(r);
                    if (bufrs.isEmpty()) {
                        this.otab.setValueAt(this.defaultValue, rown, coln);
                        continue;
                    }
                    this.otab.setValueAt(this.valueForMultiplePeak(bufrs, r), rown, coln);
                    ++nzs;
                }
            }
            this.nonzeros.add(nzs);
        }
    }

    public void setDefaultValue(String v) {
        this.defaultValue = v;
    }

    protected String valueForMultiplePeak(ArrayList<Region> bufrs, Region ref) {
        double max = Double.NEGATIVE_INFINITY;
        String maxret = "";
        for (Region r : bufrs) {
            double v;
            GenomicRegion gr = (GenomicRegion)r;
            if (!gr.overlapsWith(ref) || !((v = gr.getValue()) > max)) continue;
            max = v;
            maxret = this.maxReturn(r);
        }
        return maxret;
    }

    protected String maxReturn(Region r) {
        return this.df.format(((GenomicRegion)r).getValue());
    }

    protected GenomicRegionsBuilder merge(GenomicRegionsBuilder gba, GenomicRegionsBuilder gbb) throws Exception {
        GenomicRegionsBuilder gbt = new GenomicRegionsBuilder();
        gbt.addAll(gba);
        gbt.addAll(gbb);
        gbt.sortAll();
        return GenomicRegionsMerger.merge(gbt);
    }

    public void writeToFile(File out) throws Exception {
        this.otab.writeToFile(out);
    }

    public void writeToFile(String out) throws Exception {
        this.writeToFile(new File(out));
    }

    public ArrayList<Integer> nonZeros() {
        return this.nonzeros;
    }

    public int unionPeaks() {
        return this.gbmer.size();
    }

    public static GenomicRegionsBuilder merge(GenomicRegionsBuilder gb) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        DirectionalGenomicRegion cw = null;
        for (GenomicRegion gr : gb) {
            DirectionalGenomicRegion dr = (DirectionalGenomicRegion)gr;
            if (cw == null) {
                cw = dr;
                continue;
            }
            if (cw.overlapsWith(dr)) {
                DirectionalGenomicRegion ovl;
                cw = ovl = new DirectionalGenomicRegion(dr.chr(), dr.strand(), dr.union(cw));
                continue;
            }
            ret.add(cw);
            cw = dr;
        }
        ret.add(cw);
        return ret;
    }

    public static void main(String[] args) throws Exception {
    }
}

