/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.builder;

import fork.lib.bio.seq.parser.gtfgff.GtfFilter;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.util.ArrayList;
import java.util.Iterator;

public class GenomicRegionsModifier {
    public static GenomicRegionsBuilder getFivePrimeEnds(GenomicRegionsBuilder gb, int up, int down) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gb.iterator();
        while (it.hasNext()) {
            DirectionalGenomicRegion dr = (DirectionalGenomicRegion)it.next().clone();
            DirectionalGenomicRegion fp = dr.getFivePrimeEnd(up, down);
            dr.setLowHigh(fp.low(), fp.high());
            ret.add(dr);
        }
        ret.sortAll();
        return ret;
    }

    public static GenomicRegionsBuilder getThreePrimeEnds(GenomicRegionsBuilder gb, int up, int down) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gb.iterator();
        while (it.hasNext()) {
            DirectionalGenomicRegion dr = (DirectionalGenomicRegion)it.next().clone();
            DirectionalGenomicRegion fp = dr.getThreePrimeEnd(up, down);
            dr.setLowHigh(fp.low(), fp.high());
            ret.add(dr);
        }
        ret.sortAll();
        return ret;
    }

    public static GenomicRegionsBuilder getExtendedRegions(GenomicRegionsBuilder gb, int up, int down) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (GenomicRegion gr : gb) {
            GenomicRegion nr = null;
            if (gr instanceof DirectionalGenomicRegion) {
                DirectionalGenomicRegion dr = (DirectionalGenomicRegion)gr;
                nr = dr.getExtendedRegion(up, down);
            } else {
                nr = gr.getExtendedRegion(up, down);
            }
            if (nr == null) continue;
            ret.add(nr);
        }
        ret.sortAll();
        return ret;
    }

    public static GenomicRegionsBuilder getGenicRegions(GenomicRegionsBuilder gb, int fpd, int tpu) {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (DirectionalGenomicRegion dr : gb) {
            try {
                DirectionalGenomicRegion newr = new DirectionalGenomicRegion(dr.chr(), dr.strand(), dr.getGenicRegion(fpd, tpu));
                newr.setAttribute(dr.attr());
                newr.setID(dr.getID());
                ret.add(newr);
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static GenomicRegionsBuilder getAllIntergenicRegions(GenomicRegionsBuilder gb) throws Exception {
        return GenomicRegionsModifier.getIntergenicRegions(gb, 0);
    }

    public static GenomicRegionsBuilder getIntergenicRegions(GenomicRegionsBuilder gb, int side) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (String chr : gb.chromosomeList()) {
            ArrayList<Region> regs = gb.map.get(chr);
            for (int i = 1; i < regs.size(); ++i) {
                Region r = regs.get(i);
                Region pr = regs.get(i - 1);
                int low = (int)pr.high() + 1 + side;
                int high = (int)r.low() - 1 - side;
                try {
                    ret.add(new DirectionalGenomicRegion(chr, '+', low, high));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ret.sortAll();
        return ret;
    }

    public static GenomicRegionsBuilder getConvergentIntergenicRegions(GenomicRegionsBuilder gb) {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        gb.sortAll();
        for (String chr : gb.map.keySet()) {
            ArrayList<Region> regs = gb.map.get(chr);
            for (int i = 1; i < regs.size(); ++i) {
                DirectionalGenomicRegion pr;
                DirectionalGenomicRegion r = (DirectionalGenomicRegion)regs.get(i);
                if (r.overlapsWith(pr = (DirectionalGenomicRegion)regs.get(i - 1)) || pr.strand() != '+' || r.strand() != '-') continue;
                try {
                    ret.add(new GenomicRegion(chr, (int)pr.high() + 1, (int)r.low() - 1));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ret.sortAll();
        return ret;
    }

    public static GenomicRegionsBuilder getDivergentIntergenicRegions(GenomicRegionsBuilder gb) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        gb.sortAll();
        for (String chr : gb.map.keySet()) {
            ArrayList<Region> regs = gb.map.get(chr);
            for (int i = 1; i < regs.size(); ++i) {
                DirectionalGenomicRegion pr;
                DirectionalGenomicRegion r = (DirectionalGenomicRegion)regs.get(i);
                if (r.overlapsWith(pr = (DirectionalGenomicRegion)regs.get(i - 1)) || pr.strand() != '-' || r.strand() != '+') continue;
                try {
                    ret.add(new GenomicRegion(chr, (int)pr.high() + 1, (int)r.low() - 1));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ret.sortAll();
        return ret;
    }

    public static GenomicRegionsBuilder getSameDirectionIntergenicRegions(GenomicRegionsBuilder gb) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        for (String chr : gb.map.keySet()) {
            ArrayList<Region> regs = gb.map.get(chr);
            for (int i = 1; i < regs.size(); ++i) {
                DirectionalGenomicRegion pr;
                DirectionalGenomicRegion r = (DirectionalGenomicRegion)regs.get(i);
                if (r.overlapsWith(pr = (DirectionalGenomicRegion)regs.get(i - 1)) || pr.strand() != r.strand()) continue;
                try {
                    ret.add(new GenomicRegion(chr, (int)pr.high() + 1, (int)r.low() - 1));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ret.sortAll();
        return ret;
    }

    public static GenomicRegionsBuilder getForwardStrand(GenomicRegionsBuilder gb) {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gb.iterator();
        while (it.hasNext()) {
            DirectionalGenomicRegion dr = (DirectionalGenomicRegion)it.next().clone();
            if (!dr.isOnForwardStrand()) continue;
            ret.add(dr);
        }
        return ret;
    }

    public static GenomicRegionsBuilder getReverseStrand(GenomicRegionsBuilder gb) {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gb.iterator();
        while (it.hasNext()) {
            DirectionalGenomicRegion dr = (DirectionalGenomicRegion)it.next().clone();
            if (!dr.isOnReverseStrand()) continue;
            ret.add(dr);
        }
        return ret;
    }

    public static GenomicRegionsBuilder getComplementaryStrand(GenomicRegionsBuilder gb) {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gb.iterator();
        while (it.hasNext()) {
            DirectionalGenomicRegion dr = (DirectionalGenomicRegion)it.next().clone();
            if (dr.isOnReverseStrand()) {
                dr.setStrand('+');
            } else if (dr.isOnForwardStrand()) {
                dr.setStrand('-');
            }
            ret.add(dr);
        }
        return ret;
    }

    public static GenomicRegionsBuilder setStrand(GenomicRegionsBuilder gb, char strand) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gb.iterator();
        while (it.hasNext()) {
            ret.add(new DirectionalGenomicRegion(strand, it.next()));
        }
        return ret;
    }

    public static GenomicRegionsBuilder lengthThreshold(GenomicRegionsBuilder gb, int min, int max) {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gb.iterator();
        while (it.hasNext()) {
            GenomicRegion gr = it.next().clone();
            int l = (int)gr.getRange() + 1;
            if (l < min || l > max) continue;
            ret.add(gr);
        }
        return ret;
    }

    public static GenomicRegionsBuilder lengthGreaterThan(GenomicRegionsBuilder gb, int l) {
        return GenomicRegionsModifier.lengthThreshold(gb, l, Integer.MAX_VALUE);
    }

    public static GenomicRegionsBuilder lengthLessThan(GenomicRegionsBuilder gb, int l) {
        return GenomicRegionsModifier.lengthThreshold(gb, Integer.MIN_VALUE, l);
    }

    public static GenomicRegionsBuilder join(GenomicRegionsBuilder gb, int gap) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        ret.addAll(GenomicRegionsModifier.joinSameStrand(GenomicRegionsModifier.getForwardStrand(gb), gap));
        ret.addAll(GenomicRegionsModifier.joinSameStrand(GenomicRegionsModifier.getReverseStrand(gb), gap));
        ret.sortAll();
        return ret;
    }

    protected static GenomicRegionsBuilder joinSameStrand(GenomicRegionsBuilder gbtar, int gap) throws Exception {
        GenomicRegionsBuilder ret = new GenomicRegionsBuilder();
        Iterator<GenomicRegion> it = gbtar.iterator();
        DirectionalGenomicRegion prev = null;
        while (it.hasNext()) {
            DirectionalGenomicRegion gr = it.next().clone();
            if (prev == null || !gr.chr().equals(prev.chr())) {
                prev = gr;
                continue;
            }
            if (gr.distanceFrom(prev) < (double)gap) {
                DirectionalGenomicRegion join;
                DirectionalGenomicRegion dr = gr;
                prev = join = new DirectionalGenomicRegion(dr.chr(), dr.strand(), (int)Math.min(dr.low(), prev.low()), (int)Math.max(dr.high(), prev.high()));
                continue;
            }
            prev.setID("");
            ret.add(prev);
            prev = gr;
        }
        return ret;
    }

    public static GenomicRegionsBuilder applyGtfFilter(GenomicRegionsBuilder gb, GtfFilter filt) throws Exception {
        if (filt == null) {
            filt = GtfFilter.proteinCoding();
        }
        return filt.apply(gb);
    }
}

