/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import fork.lib.math.applied.stat.Distribution;
import java.util.ArrayList;

public abstract class LandscapeBuffer {
    public abstract String[] getChromosomeList();

    public abstract String[] getUnsortedChromosomeList();

    public abstract boolean containsChromosome(String var1);

    public abstract Landscape2D getLandscape2DForChromosome(String var1);

    public double totalArea() {
        double area = 0.0;
        String[] chrs = this.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            ArrayList<Region> rs = this.getLandscape2DForChromosome(chr).getRegions();
            for (int j = 0; j < rs.size(); ++j) {
                Region r = rs.get(j);
                area += Double.parseDouble(r.attr().toString()) * (r.getRange() + 1.0);
            }
        }
        return area;
    }

    public int valuedLength() {
        int len = 0;
        String[] chrs = this.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            System.out.println(chr);
            ArrayList<Region> rs = this.getLandscape2DForChromosome(chr).getRegions();
            for (int j = 0; j < rs.size(); ++j) {
                Region r = rs.get(j);
                len = (int)((double)len + (r.getRange() + 1.0));
            }
        }
        return len;
    }

    public int totalLength() {
        int len = 0;
        String[] chrs = this.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            ArrayList<Region> rs = this.getLandscape2DForChromosome(chr).getRegions();
            if (rs.isEmpty()) continue;
            len = (int)((double)len + ((double)((int)rs.get(rs.size() - 1).high()) - rs.get(0).low() + 1.0));
        }
        return len;
    }

    public Distribution getDistributionNonZero() {
        Distribution d = new Distribution();
        String[] chrs = this.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            System.out.print(chr + "  ");
            ArrayList<Region> rs = this.getLandscape2DForChromosome(chr).getRegions();
            for (int j = 0; j < rs.size(); ++j) {
                Region r = rs.get(j);
                double v = Double.parseDouble(r.attr().toString());
                d.add((Double)v, (int)(r.high() - r.low() + 1.0));
            }
        }
        System.out.println();
        return d;
    }

    public Distribution getDistribution() {
        Distribution d = new Distribution();
        String[] chrs = this.getUnsortedChromosomeList();
        for (int k = 0; k < chrs.length; ++k) {
            String chr = chrs[k];
            System.out.print(chr + "  ");
            ArrayList<Region> rs = this.getLandscape2DForChromosome(chr).getRegions();
            Region pr = rs.get(0);
            double pv = Double.parseDouble(pr.attr().toString());
            d.add((Double)pv, (int)(pr.high() - pr.low() + 1.0));
            for (int i = 1; i < rs.size(); ++i) {
                Region r = rs.get(i);
                double v = Double.parseDouble(r.attr().toString());
                d.add(new double[]{0.0, (int)(r.low() - (pr.high() + 1.0) + 1.0)});
                d.add((Double)v, (int)(r.high() - r.low() + 1.0));
                pr = r;
            }
        }
        System.out.println();
        return d;
    }

    public void print() {
        String[] chrs = this.getUnsortedChromosomeList();
        System.out.println(chrs.length);
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            ArrayList<Region> rs = this.getLandscape2DForChromosome(chr).getRegions();
            for (int j = 0; j < rs.size(); ++j) {
                Region r = rs.get(j);
                System.out.println(chr + "  " + (int)r.low() + "  " + (int)r.high() + "  " + (Double)r.attr());
            }
        }
    }
}

