/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.parser.bedgraph.BedGraphBuffer;
import fork.lib.bio.seq.parser.bedgraph.BedGraphExporter;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class LandscapeBufferTransformer {
    protected LandscapeBuffer lb;
    public DecimalFormat df = new DecimalFormat("#.##");

    public LandscapeBufferTransformer(LandscapeBuffer lb) throws Exception {
        this.lb = lb;
    }

    public void divideBy(double fac, File out, String tit) throws Exception {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        BedGraphExporter.writeTitle(bw, tit);
        String[] chrs = this.lb.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            ArrayList<Region> regs = this.lb.getLandscape2DForChromosome(chr).getRegions();
            for (int j = 0; j < regs.size(); ++j) {
                Region r = regs.get(j);
                double v = Double.parseDouble(r.attr().toString());
                double nv = v / fac;
                bw.write(chr + "\t" + (int)r.low() + "\t" + (int)(r.high() + 1.0) + "\t" + this.df.format(nv) + "\n");
            }
        }
        bw.close();
    }

    public static void main(String[] args) throws Exception {
        File d = new File("E:\\muxingu\\mystudy\\phd\\files\\data\\rna-seq");
        File f = new File(d + "/strand_rna_569-4kr-cen_sd-ura_20140313-r1_pe1_sacCer1_for.wig");
        BedGraphBuffer lb = new BedGraphBuffer(f);
        LandscapeBufferTransformer lt = new LandscapeBufferTransformer(lb);
        lt.divideBy(2.0, new File(d + "/test.wig"), "xxx");
    }
}

