/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.base.format.collection.FormatOp1D;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class LandscapeBuilder
extends LandscapeBuffer {
    protected HashMap<String, Landscape2D> lands;

    public LandscapeBuilder() {
        this.init();
    }

    public LandscapeBuilder(LandscapeBuilder b) throws Exception {
        this.init();
        for (String chr : b.lands.keySet()) {
            ArrayList<Region> rs = b.lands.get(chr).getRegions();
            for (int i = 0; i < rs.size(); ++i) {
                Region r = rs.get(i);
                r.setAttribute(Double.parseDouble(r.attr().toString()));
                this.add(chr, r);
            }
        }
    }

    protected void init() {
        this.lands = new HashMap();
    }

    public HashMap<String, Landscape2D> getHashMap() {
        return this.lands;
    }

    public void add(String chr, Region r) throws Exception {
        if (chr == null || r == null) {
            return;
        }
        if (!this.lands.containsKey(chr)) {
            this.lands.put(chr, new Landscape2D());
        }
        this.lands.get(chr).add(r);
    }

    public void add(GenomicRegion r) throws Exception {
        r.setAttribute(r.getValue());
        this.add(r.chr(), r);
    }

    public void addNoCheckOrder(String chr, Region r) throws Exception {
        if (chr == null || r == null) {
            return;
        }
        if (!this.lands.containsKey(chr)) {
            this.lands.put(chr, new Landscape2D());
        }
        this.lands.get(chr).addNoCheckOrder(r);
    }

    public void addAll(String chr, Landscape2D ls) throws Exception {
        if (chr == null || ls == null || ls.getRegions().isEmpty()) {
            return;
        }
        if (!this.lands.containsKey(chr)) {
            this.lands.put(chr, new Landscape2D());
        }
        this.lands.get(chr).addAll(ls);
    }

    public void sortAll() throws Exception {
        Iterator<String> it = this.lands.keySet().iterator();
        while (it.hasNext()) {
            this.lands.get(it.next()).sortByX();
        }
    }

    public void removeDuplicate() {
        Iterator<String> it = this.lands.keySet().iterator();
        while (it.hasNext()) {
            this.lands.get(it.next()).removeDuplicate();
        }
    }

    protected double transform(double v) {
        return v;
    }

    @Override
    public String[] getChromosomeList() {
        Object[] ret = new String[this.lands.keySet().size()];
        this.lands.keySet().toArray(ret);
        Arrays.sort(ret);
        return ret;
    }

    @Override
    public String[] getUnsortedChromosomeList() {
        return FormatOp1D.objToString(this.lands.keySet().toArray());
    }

    @Override
    public boolean containsChromosome(String chr) {
        return this.lands.containsKey(chr);
    }

    @Override
    public Landscape2D getLandscape2DForChromosome(String chr) {
        return this.lands.get(chr);
    }

    public LandscapeBuilder getLandscapeForChromosome(String chr) throws Exception {
        LandscapeBuilder ret = new LandscapeBuilder();
        if (!this.lands.containsKey(chr)) {
            return ret;
        }
        ret.addAll(chr, this.lands.get(chr));
        return ret;
    }

    public void removeChromosome(String chr) {
        if (this.lands.containsKey(chr)) {
            this.lands.remove(chr);
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

