/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.parser.bedgraph.BedGraphExporter;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2DBuffer;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;

public class LandscapeComparatorBuffer {
    protected LandscapeBuffer lb;
    protected LandscapeBuffer lbref;
    protected LandscapeBuilder lbout = new LandscapeBuilder();

    public LandscapeComparatorBuffer(LandscapeBuffer lb, LandscapeBuffer lbref) {
        this.lb = lb;
        this.lbref = lbref;
    }

    public void start() throws Exception {
        String[] chrs = this.lb.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            System.out.print(chr + "  ");
            ArrayList<Region> regs = this.lb.getLandscape2DForChromosome(chr).getRegions();
            Landscape2DBuffer rb = new Landscape2DBuffer(this.lbref.getLandscape2DForChromosome(chr));
            for (int j = 0; j < regs.size(); ++j) {
                Region reg = regs.get(j);
                double v = (Double)reg.attr();
                int k = (int)reg.low();
                while ((double)k <= reg.high()) {
                    try {
                        double nv;
                        Region nt = new Region(k, k);
                        ArrayList<Region> bufrs = rb.reloadAndGetList(nt);
                        double refv = 1.0;
                        for (int l = 0; l < bufrs.size(); ++l) {
                            Region bufr = bufrs.get(l);
                            if (!bufr.overlapsWith(nt)) continue;
                            refv = (Double)bufr.attr();
                            break;
                        }
                        if (this.ifAdd(nv = this.newValue(v, refv))) {
                            nt.setAttribute(nv);
                            this.lbout.add(chr, nt);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++k;
                }
            }
        }
    }

    public void appendToFile(BufferedWriter bw) throws Exception {
        this.start();
        BedGraphExporter be = new BedGraphExporter(this.lbout);
        be.appendToFile(bw);
    }

    public double newValue(double v, double refv) {
        return v / refv;
    }

    public LandscapeBuilder landscapeBuilderOutput() {
        return this.lbout;
    }

    protected boolean ifAdd(double v) {
        return v != 0.0;
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("C:\\muxingu\\data\\test");
        LandscapeComparatorBuffer lc = new LandscapeComparatorBuffer(new BedGraphReader(new File(dir + "/test_sig.wig")).getLandscapeBuilder(), new BedGraphReader(new File(dir + "/test_bg.wig")).getLandscapeBuilder());
        File out = new File(dir + "/out.wig");
    }
}

