/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.algebra.elementary.set.continuous.RegionsOp;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import fork.lib.math.analgeo.euclidean.d2.Landscape2DBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class LandscapeExtractor {
    public static DecimalFormat df = new DecimalFormat("#.##");
    protected LandscapeBuilder lb;
    protected GenomicRegionsBuilder gb;
    public LandscapeBuilder lbout;

    public LandscapeExtractor(LandscapeBuilder lb, GenomicRegionsBuilder gb, boolean sortlb, boolean sortgb) throws Exception {
        this.lb = lb;
        if (sortlb) {
            this.lb.sortAll();
        }
        this.gb = gb;
        if (sortgb) {
            this.gb.sortAll();
        }
        this.init();
    }

    public LandscapeExtractor(LandscapeBuilder lb, GenomicRegionsBuilder gb) throws Exception {
        this(lb, gb, false, false);
    }

    protected void init() throws Exception {
        this.lbout = new LandscapeBuilder();
        HashMap<String, Landscape2D> ents = this.lb.lands;
        String[] chrs = this.gb.getChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            if (chr == null || !ents.containsKey(chr)) continue;
            ArrayList<Region> regs = RegionsOp.merge(this.gb.getRegionsForChromosome(chr));
            Landscape2DBuffer tss = new Landscape2DBuffer(ents.get(chr));
            for (int j = 0; j < regs.size(); ++j) {
                Region reg = regs.get(j);
                ArrayList<Region> bufs = tss.reloadAndGetList(reg);
                for (int k = 0; k < bufs.size(); ++k) {
                    Region br = bufs.get(k);
                    if (!br.overlapsWith(reg)) continue;
                    if (!this.lbout.lands.containsKey(chr)) {
                        this.lbout.add(chr, br);
                        continue;
                    }
                    ArrayList<Region> lbrs = this.lbout.lands.get(chr).getRegions();
                    if (lbrs.isEmpty() || !br.higherThan(lbrs.get(lbrs.size() - 1))) continue;
                    this.lbout.add(chr, br);
                }
            }
        }
    }

    public LandscapeBuilder toLandscapeBuilder() throws Exception {
        return this.lbout;
    }
}

