/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.applied.learning.peak.EMPeakDetectorParam;
import fork.lib.math.applied.learning.peak.HeightPeakDetectorParam;
import fork.lib.math.applied.learning.peak.PeakDetector;
import fork.lib.math.applied.learning.peak.PeakDetectorParam;

public class LandscapePeakDetector {
    protected LandscapeBuilder lb;
    protected PeakDetectorParam par;
    protected EMPeakDetectorParam emPar;
    protected HeightPeakDetectorParam hPar;
    public GenomicRegionsBuilder gb;

    public LandscapePeakDetector(LandscapeBuilder lb, PeakDetectorParam par, EMPeakDetectorParam emPar, HeightPeakDetectorParam hPar) throws Exception {
        this.lb = lb;
        this.par = par;
        this.emPar = emPar;
        this.hPar = hPar;
        this.init();
    }

    protected LandscapePeakDetector(LandscapeBuilder lb) throws Exception {
        this(lb, null, null, null);
    }

    protected void init() throws Exception {
        this.gb = new GenomicRegionsBuilder();
        if (this.par == null) {
            this.par = new PeakDetectorParam();
        }
        if (this.emPar == null) {
            this.emPar = new EMPeakDetectorParam();
        }
        if (this.hPar == null) {
            this.hPar = new HeightPeakDetectorParam();
        }
        for (String chr : this.lb.lands.keySet()) {
            System.out.print(chr + "  ");
            PeakDetector pd = new PeakDetector(this.lb.lands.get(chr), this.par, this.emPar, this.hPar);
            this.gb.addAll(chr, pd.regs);
        }
        System.out.println();
        this.gb.sortAll();
    }
}

