/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeScoringResultEntry;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2DBuffer;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class LandscapeScoring {
    public static DecimalFormat df = new DecimalFormat("#.###");
    protected LandscapeBuffer lb;
    protected GenomicRegionsBuilder gb;
    protected ArrayList<LandscapeScoringResultEntry> res;

    public LandscapeScoring(LandscapeBuffer lb, GenomicRegionsBuilder gb) throws Exception {
        this.lb = lb;
        this.gb = gb;
        this.init();
    }

    protected void init() throws Exception {
        int j;
        ArrayList<Region> regs;
        this.res = new ArrayList();
        String[] chrs = this.lb.getUnsortedChromosomeList();
        for (int i = 0; i < chrs.length; ++i) {
            String chr = chrs[i];
            if (!this.gb.containsChromosome(chr)) continue;
            Landscape2DBuffer ts = new Landscape2DBuffer(this.lb.getLandscape2DForChromosome(chr));
            regs = this.gb.getRegionsForChromosome(chr);
            for (j = 0; j < regs.size(); ++j) {
                GenomicRegion gr = (GenomicRegion)regs.get(j);
                ArrayList<Region> bufs = ts.reloadAndGetList(gr);
                this.res.add(new LandscapeScoringResultEntry(gr.clone(), this.score(bufs, gr)));
            }
        }
        String[] chrsg = this.gb.getChromosomeList();
        for (int i = 0; i < chrsg.length; ++i) {
            String chr = chrsg[i];
            if (this.lb.containsChromosome(chr)) continue;
            regs = this.gb.getRegionsForChromosome(chr);
            for (j = 0; j < regs.size(); ++j) {
                this.res.add(new LandscapeScoringResultEntry((GenomicRegion)regs.get(j).clone(), new double[]{0.0}));
            }
        }
    }

    protected double[] score(ArrayList<Region> bufs, GenomicRegion gr) throws Exception {
        return new double[]{Landscape2DBuffer.getArea(bufs, gr) / gr.getRange()};
    }

    public ArrayList<LandscapeScoringResultEntry> getResultEntries() {
        return this.res;
    }

    public void writeToBedFile(File out) throws Exception {
        LandscapeScoringResultEntry.writeToBedFile(this.res, out);
    }

    public void writeToBedFile(String out) throws Exception {
        this.writeToBedFile(new File(out));
    }
}

