/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.parser.bed.BedAttribute;
import fork.lib.bio.seq.parser.bed.BedWriter;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.math.applied.stat.Distribution;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class LandscapeScoringResultEntry {
    public GenomicRegion gr;
    public double[] scores;
    public Object attr;

    public LandscapeScoringResultEntry(GenomicRegion gr, double[] scores) {
        this.gr = gr;
        this.scores = scores;
    }

    public static Distribution toDistribution(ArrayList<LandscapeScoringResultEntry> res, int ind) {
        Distribution dis = new Distribution();
        for (int i = 0; i < res.size(); ++i) {
            if (res.get((int)i).scores.length <= ind) continue;
            dis.add((Double)res.get((int)i).scores[ind]);
        }
        return dis;
    }

    public static void writeToBedFile(ArrayList<LandscapeScoringResultEntry> res, File out) throws Exception {
        BedWriter be = new BedWriter(LandscapeScoringResultEntry.toGenomicRegionsBuilder(res, 0));
        be.writeToFile(out);
    }

    public static GenomicRegionsBuilder toGenomicRegionsBuilder(ArrayList<LandscapeScoringResultEntry> res, int ind) throws Exception {
        GenomicRegionsBuilder gb = new GenomicRegionsBuilder();
        for (int i = 0; i < res.size(); ++i) {
            LandscapeScoringResultEntry ent = res.get(i);
            GenomicRegion gr = ent.gr;
            double[] vs = ent.scores;
            BedAttribute ba = new BedAttribute();
            if (vs.length >= 1) {
                gr.setValue(vs[0]);
                if (vs.length > 1) {
                    ArrayList<String> other = new ArrayList<String>();
                    for (int k = 1; k < vs.length; ++k) {
                        other.add(Double.toString(vs[k]));
                    }
                    ba.setFieldOther(other);
                }
            }
            gr.setAttribute(ba);
            gb.add(gr);
        }
        gb.sortAll();
        return gb;
    }

    public static HashMap<GenomicRegion, Double> toHashMap(ArrayList<LandscapeScoringResultEntry> res, int ind) throws Exception {
        HashMap<GenomicRegion, Double> ret = new HashMap<GenomicRegion, Double>();
        for (int i = 0; i < res.size(); ++i) {
            LandscapeScoringResultEntry r = res.get(i);
            ret.put(r.gr, r.scores[ind]);
        }
        return ret;
    }
}

