/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.parser.bed.BedReader;
import fork.lib.bio.seq.parser.bedgraph.BedGraphReader;
import fork.lib.bio.seq.region.GenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import fork.lib.bio.seq.region.builder.GenomicRegionsModifier;
import fork.lib.bio.seq.region.landscape.LandscapeBuffer;
import fork.lib.bio.seq.region.landscape.LandscapeScoring;
import fork.lib.bio.seq.region.landscape.LandscapeScoringResultEntry;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2DBuffer;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class LandscapeScoringStrand {
    public static DecimalFormat df = new DecimalFormat("#.###");
    protected LandscapeBuffer lbf;
    protected LandscapeBuffer lbr;
    protected GenomicRegionsBuilder gb;
    protected ArrayList<LandscapeScoringResultEntry> res;

    public LandscapeScoringStrand(LandscapeBuffer lbf, LandscapeBuffer lbr, GenomicRegionsBuilder gb) throws Exception {
        this.lbf = lbf;
        this.lbr = lbr;
        this.gb = gb;
        this.init();
    }

    public LandscapeScoringStrand(File lbff, File lbrf, File gbf) throws Exception {
        this(new BedGraphReader(lbff).getLandscapeBuilder(), new BedGraphReader(lbrf).getLandscapeBuilder(), new BedReader(gbf).getGenomicRegionsBuilder());
    }

    private void init() throws Exception {
        this.res = new ArrayList();
        this.startStrand(GenomicRegionsModifier.getForwardStrand(this.gb), this.lbf);
        this.startStrand(GenomicRegionsModifier.getReverseStrand(this.gb), this.lbr);
    }

    public ArrayList<LandscapeScoringResultEntry> getResultEntries() {
        return this.res;
    }

    protected void startStrand(GenomicRegionsBuilder gbt, LandscapeBuffer lb) throws Exception {
        ArrayList r = new LandscapeScoring((LandscapeBuffer)lb, (GenomicRegionsBuilder)gbt){

            @Override
            protected double[] score(ArrayList<Region> bufs, GenomicRegion gr) throws Exception {
                return LandscapeScoringStrand.this.scoreStrand(bufs, gr);
            }
        }.res;
        this.res.addAll(r);
    }

    protected double[] scoreStrand(ArrayList<Region> bufs, GenomicRegion gr) throws Exception {
        return new double[]{Landscape2DBuffer.getArea(bufs, gr) / gr.getRange()};
    }

    public void writeToBedFile(File out) throws Exception {
        LandscapeScoringResultEntry.writeToBedFile(this.res, out);
    }
}

