/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq.region.landscape;

import fork.lib.bio.seq.region.landscape.LandscapeBuilder;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import java.util.ArrayList;

public class LandscapeTransformer {
    protected LandscapeBuilder lb;
    protected Transformer tr;
    protected Checker ch;

    public LandscapeTransformer(LandscapeBuilder lb) {
        this.lb = lb;
        this.init();
    }

    protected void init() {
        this.tr = new Transformer();
        this.ch = new Checker();
    }

    protected void transform() {
        try {
            for (String chr : this.lb.lands.keySet()) {
                ArrayList<Region> rs = this.lb.lands.get(chr).getRegions();
                Landscape2D ll = new Landscape2D();
                for (int i = 0; i < rs.size(); ++i) {
                    Region r = rs.get(i);
                    double nv = this.tr.transform(Double.parseDouble(r.attr().toString()));
                    r.setAttribute(nv);
                    if (this.ch.ifRemove(r)) continue;
                    ll.add(r);
                }
                this.lb.lands.put(chr, ll);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void subtract(final double thr) {
        this.tr = new Transformer(){
            double thresh;
            {
                this.thresh = thr;
            }

            @Override
            public double transform(double v) {
                return v - this.thresh;
            }
        };
        this.ch = new Checker(){

            @Override
            public boolean ifRemove(Region r) {
                double v = Double.parseDouble(r.attr().toString());
                return v <= 0.0;
            }
        };
        this.transform();
    }

    public void subtractNotRemove(final double thr) {
        this.tr = new Transformer(){
            double thresh;
            {
                this.thresh = thr;
            }

            @Override
            public double transform(double v) {
                return v - this.thresh;
            }
        };
        this.ch = new Checker();
        this.transform();
    }

    public void divideBy(final double div) {
        this.tr = new Transformer(){
            double d;
            {
                this.d = div;
            }

            @Override
            public double transform(double v) {
                return v / this.d;
            }
        };
        this.ch = new Checker();
        this.transform();
    }

    public void unlog(final double base) {
        this.tr = new Transformer(){

            @Override
            public double transform(double v) {
                return Math.pow(base, v);
            }
        };
        this.ch = new Checker();
        this.transform();
    }

    public void unlog() {
        this.unlog(Math.E);
    }

    public void log(final double base) {
        this.tr = new Transformer(){

            @Override
            public double transform(double v) {
                return Math.log(v) / Math.log(base);
            }
        };
        this.ch = new Checker();
        this.transform();
    }

    public void selectLength(double min, double max) throws Exception {
        for (String chr : this.lb.lands.keySet()) {
            ArrayList<Region> rs = this.lb.lands.get(chr).getRegions();
            Landscape2D ll = new Landscape2D();
            int ind = -1;
            ArrayList<Region> bufs = new ArrayList<Region>();
            while (++ind < rs.size()) {
                Region r = rs.get(ind);
                if (bufs.isEmpty()) {
                    bufs.add(r);
                    continue;
                }
                Region pr = (Region)bufs.get(bufs.size() - 1);
                if (pr.high() == r.low() - 1.0) {
                    bufs.add(r);
                    continue;
                }
                double size = ((Region)bufs.get(bufs.size() - 1)).high() - ((Region)bufs.get(0)).low() + 1.0;
                if (size >= min && size < max) {
                    for (int i = 0; i < bufs.size(); ++i) {
                        ll.add((Region)bufs.get(i));
                    }
                }
                bufs = new ArrayList();
            }
            this.lb.lands.put(chr, ll);
        }
    }

    public void selectHeight(double min, double max) throws Exception {
        for (String chr : this.lb.lands.keySet()) {
            ArrayList<Region> rs = this.lb.lands.get(chr).getRegions();
            Landscape2D ll = new Landscape2D();
            for (Region r : rs) {
                double hei = (Double)r.attr();
                if (!(hei > min) || !(hei < max)) continue;
                ll.add(r);
            }
            this.lb.lands.put(chr, ll);
        }
    }

    public static void main(String[] args) throws Exception {
        int a = 0;
        while (a < 5) {
            if (++a == 3) {
                System.out.println("xxx");
                continue;
            }
            System.out.println(a);
        }
    }

    class Checker {
        Checker() {
        }

        public boolean ifRemove(Region r) {
            return false;
        }
    }

    class Transformer {
        Transformer() {
        }

        public double transform(double v) {
            return v;
        }
    }
}

